/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.config;

import java.util.function.Supplier;
import mezz.jei.common.config.file.IConfigCategoryBuilder;
import mezz.jei.common.config.file.IConfigSchemaBuilder;
import org.jetbrains.annotations.Nullable;

public final class DebugConfig {
    @Nullable
    private static DebugConfig instance;
    private final Supplier<Boolean> debugModeEnabled;
    private final Supplier<Boolean> debugInputsEnabled;

    public static void create(IConfigSchemaBuilder schema) {
        instance = new DebugConfig(schema);
    }

    private DebugConfig(IConfigSchemaBuilder schema) {
        IConfigCategoryBuilder advanced = schema.addCategory("debug");
        this.debugModeEnabled = advanced.addBoolean("DebugMode", false, "Debug mode enabled");
        this.debugInputsEnabled = advanced.addBoolean("DebugInputs", false, "Debug inputs enabled");
    }

    public static boolean isDebugModeEnabled() {
        if (instance == null) {
            return false;
        }
        return DebugConfig.instance.debugModeEnabled.get();
    }

    public static boolean isDebugInputsEnabled() {
        if (instance == null) {
            return false;
        }
        return DebugConfig.instance.debugInputsEnabled.get();
    }
}

