/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import com.google.common.base.Preconditions;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ImmutableRect2i;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_518;
import org.jetbrains.annotations.Nullable;

public class GuiProperties
implements IGuiProperties {
    private final Class<? extends class_437> screenClass;
    private final int guiLeft;
    private final int guiTop;
    private final int guiXSize;
    private final int guiYSize;
    private final int screenWidth;
    private final int screenHeight;

    @Nullable
    public static GuiProperties create(class_465<?> containerScreen) {
        class_518 r;
        ImmutableRect2i bookArea;
        if (containerScreen.field_22789 <= 0 || containerScreen.field_22790 <= 0) {
            return null;
        }
        IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
        int x = screenHelper.getGuiLeft(containerScreen);
        int y = screenHelper.getGuiTop(containerScreen);
        int width = screenHelper.getXSize(containerScreen);
        int height = screenHelper.getYSize(containerScreen);
        if (containerScreen instanceof class_518 && !(bookArea = screenHelper.getBookArea(r = (class_518)containerScreen)).isEmpty()) {
            width += x - bookArea.getX();
            x = bookArea.getX();
        }
        if (x < 0) {
            width -= x;
            x = 0;
        }
        if (y < 0) {
            height -= y;
            y = 0;
        }
        if (width <= 0 || height <= 0) {
            return null;
        }
        return new GuiProperties(containerScreen.getClass(), x, y, width, height, containerScreen.field_22789, containerScreen.field_22790);
    }

    public static boolean areEqual(@Nullable IGuiProperties a, @Nullable IGuiProperties b) {
        if (a == b) {
            return true;
        }
        return a != null && b != null && a.getScreenClass().equals(b.getScreenClass()) && a.getGuiLeft() == b.getGuiLeft() && a.getGuiXSize() == b.getGuiXSize() && a.getScreenWidth() == b.getScreenWidth() && a.getScreenHeight() == b.getScreenHeight();
    }

    public static ImmutableRect2i getScreenRectangle(IGuiProperties guiProperties) {
        return new ImmutableRect2i(0, 0, guiProperties.getScreenWidth(), guiProperties.getScreenHeight());
    }

    public static ImmutableRect2i getGuiRectangle(IGuiProperties guiProperties) {
        return new ImmutableRect2i(guiProperties.getGuiLeft(), guiProperties.getGuiTop(), guiProperties.getGuiXSize(), guiProperties.getGuiYSize());
    }

    public static int getGuiRight(IGuiProperties guiProperties) {
        return guiProperties.getGuiLeft() + guiProperties.getGuiXSize();
    }

    public static int getGuiBottom(IGuiProperties guiProperties) {
        return guiProperties.getGuiTop() + guiProperties.getGuiYSize();
    }

    public GuiProperties(Class<? extends class_437> screenClass, int guiLeft, int guiTop, int guiXSize, int guiYSize, int screenWidth, int screenHeight) {
        Preconditions.checkArgument((guiLeft >= 0 ? 1 : 0) != 0, (Object)"guiLeft must be >= 0");
        Preconditions.checkArgument((guiTop >= 0 ? 1 : 0) != 0, (Object)"guiTop must be >= 0");
        Preconditions.checkArgument((guiXSize > 0 ? 1 : 0) != 0, (Object)"guiXSize must be > 0");
        Preconditions.checkArgument((guiYSize > 0 ? 1 : 0) != 0, (Object)"guiYSize must be > 0");
        Preconditions.checkArgument((screenWidth > 0 ? 1 : 0) != 0, (Object)"screenWidth must be > 0");
        Preconditions.checkArgument((screenHeight > 0 ? 1 : 0) != 0, (Object)"screenHeight must be > 0");
        this.screenClass = screenClass;
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.guiXSize = guiXSize;
        this.guiYSize = guiYSize;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    @Override
    public Class<? extends class_437> getScreenClass() {
        return this.screenClass;
    }

    @Override
    public int getGuiLeft() {
        return this.guiLeft;
    }

    @Override
    public int getGuiTop() {
        return this.guiTop;
    }

    @Override
    public int getGuiXSize() {
        return this.guiXSize;
    }

    @Override
    public int getGuiYSize() {
        return this.guiYSize;
    }

    @Override
    public int getScreenWidth() {
        return this.screenWidth;
    }

    @Override
    public int getScreenHeight() {
        return this.screenHeight;
    }
}

