/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.elements;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.common.gui.TooltipRenderer;
import mezz.jei.common.gui.elements.DrawableBlank;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.gui.elements.GuiIconButton;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.UserInput;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public abstract class GuiIconToggleButton {
    private final IDrawable offIcon;
    private final IDrawable onIcon;
    private final GuiIconButton button;
    private ImmutableRect2i area;

    public GuiIconToggleButton(IDrawable offIcon, IDrawable onIcon, Textures textures) {
        this.offIcon = offIcon;
        this.onIcon = onIcon;
        this.button = new GuiIconButton(new DrawableBlank(0, 0), b -> {}, textures);
        this.area = ImmutableRect2i.EMPTY;
    }

    public void updateBounds(ImmutableRect2i area) {
        this.button.method_25358(area.getWidth());
        this.button.setHeight(area.getHeight());
        this.button.method_46421(area.getX());
        this.button.method_46419(area.getY());
        this.area = area;
    }

    public void draw(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        this.button.method_25394(poseStack, mouseX, mouseY, partialTicks);
        IDrawable icon = this.isIconToggledOn() ? this.onIcon : this.offIcon;
        icon.draw(poseStack, this.button.method_46426() + 2, this.button.method_46427() + 2);
    }

    public final boolean isMouseOver(double mouseX, double mouseY) {
        return this.area.contains(mouseX, mouseY);
    }

    public IUserInputHandler createInputHandler() {
        return new UserInputHandler();
    }

    public final void drawTooltips(class_4587 poseStack, int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
            this.getTooltips(tooltip);
            TooltipRenderer.drawHoveringText(poseStack, tooltip, mouseX, mouseY);
        }
    }

    protected abstract void getTooltips(List<class_2561> var1);

    protected abstract boolean isIconToggledOn();

    protected abstract boolean onMouseClicked(UserInput var1);

    private class UserInputHandler
    implements IUserInputHandler {
        private UserInputHandler() {
        }

        @Override
        public final Optional<IUserInputHandler> handleUserInput(class_437 screen, UserInput input, IInternalKeyMappings keyBindings) {
            if (GuiIconToggleButton.this.isMouseOver(input.getMouseX(), input.getMouseY())) {
                IUserInputHandler handler = GuiIconToggleButton.this.button.createInputHandler();
                return handler.handleUserInput(screen, input, keyBindings).flatMap(handled -> {
                    if (GuiIconToggleButton.this.onMouseClicked(input)) {
                        return Optional.of(this);
                    }
                    return Optional.empty();
                });
            }
            return Optional.empty();
        }
    }
}

