/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IRecipesGui;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.gui.TooltipRenderer;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.ClickableIngredientInternal;
import mezz.jei.common.input.IClickableIngredientInternal;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.common.util.StringUtil;
import mezz.jei.gui.GuiProperties;
import mezz.jei.gui.elements.GuiIconButtonSmall;
import mezz.jei.gui.input.IRecipeFocusSource;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.InputType;
import mezz.jei.gui.input.MouseUtil;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.IRecipeLogicStateListener;
import mezz.jei.gui.recipes.RecipeCatalysts;
import mezz.jei.gui.recipes.RecipeGuiLogic;
import mezz.jei.gui.recipes.RecipeGuiTabs;
import mezz.jei.gui.recipes.RecipeTransferButton;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

public class RecipesGui
extends class_437
implements IRecipesGui,
IRecipeFocusSource,
IRecipeLogicStateListener {
    private static final int borderPadding = 6;
    private static final int innerPadding = 14;
    private static final int buttonWidth = 13;
    private static final int buttonHeight = 13;
    private final IRecipeTransferManager recipeTransferManager;
    private final IModIdHelper modIdHelper;
    private final IClientConfig clientConfig;
    private final IInternalKeyMappings keyBindings;
    private final Textures textures;
    private final IFocusFactory focusFactory;
    private final IIngredientManager ingredientManager;
    private int headerHeight;
    private final IRecipeGuiLogic logic;
    private final List<IRecipeLayoutDrawable<?>> recipeLayouts = new ArrayList();
    private String pageString = "1/1";
    private class_2561 title = class_5244.field_39003;
    private final DrawableNineSliceTexture background;
    private final RecipeCatalysts recipeCatalysts;
    private final RecipeGuiTabs recipeGuiTabs;
    private final List<RecipeTransferButton> recipeTransferButtons;
    private final GuiIconButtonSmall nextRecipeCategory;
    private final GuiIconButtonSmall previousRecipeCategory;
    private final GuiIconButtonSmall nextPage;
    private final GuiIconButtonSmall previousPage;
    @Nullable
    private class_437 parentScreen;
    private ImmutableRect2i area = ImmutableRect2i.EMPTY;
    private ImmutableRect2i titleArea = ImmutableRect2i.EMPTY;
    private ImmutableRect2i titleStringArea = ImmutableRect2i.EMPTY;
    private boolean init = false;

    public RecipesGui(IRecipeManager recipeManager, IRecipeTransferManager recipeTransferManager, IIngredientManager ingredientManager, IModIdHelper modIdHelper, IClientConfig clientConfig, Textures textures, IInternalKeyMappings keyBindings, IFocusFactory focusFactory) {
        super((class_2561)class_2561.method_43470((String)"Recipes"));
        this.textures = textures;
        this.recipeTransferButtons = new ArrayList<RecipeTransferButton>();
        this.recipeTransferManager = recipeTransferManager;
        this.ingredientManager = ingredientManager;
        this.modIdHelper = modIdHelper;
        this.clientConfig = clientConfig;
        this.keyBindings = keyBindings;
        this.logic = new RecipeGuiLogic(recipeManager, recipeTransferManager, this, focusFactory);
        this.recipeCatalysts = new RecipeCatalysts(textures, recipeManager);
        this.recipeGuiTabs = new RecipeGuiTabs(this.logic, textures, ingredientManager);
        this.focusFactory = focusFactory;
        this.field_22787 = class_310.method_1551();
        IDrawableStatic arrowNext = textures.getArrowNext();
        IDrawableStatic arrowPrevious = textures.getArrowPrevious();
        this.nextRecipeCategory = new GuiIconButtonSmall(0, 0, 13, 13, arrowNext, b -> this.logic.nextRecipeCategory(), textures);
        this.previousRecipeCategory = new GuiIconButtonSmall(0, 0, 13, 13, arrowPrevious, b -> this.logic.previousRecipeCategory(), textures);
        this.nextPage = new GuiIconButtonSmall(0, 0, 13, 13, arrowNext, b -> this.logic.nextPage(), textures);
        this.previousPage = new GuiIconButtonSmall(0, 0, 13, 13, arrowPrevious, b -> this.logic.previousPage(), textures);
        this.background = textures.getRecipeGuiBackground();
    }

    private static void drawCenteredStringWithShadow(class_4587 poseStack, class_327 font, String string, ImmutableRect2i area) {
        ImmutableRect2i textArea = MathUtil.centerTextArea(area, font, string);
        font.method_1720(poseStack, string, (float)textArea.getX(), (float)textArea.getY(), -1);
    }

    private static void drawCenteredStringWithShadow(class_4587 poseStack, class_327 font, class_2561 text, ImmutableRect2i area) {
        ImmutableRect2i textArea = MathUtil.centerTextArea(area, font, (class_5348)text);
        font.method_30881(poseStack, text, (float)textArea.getX(), (float)textArea.getY(), -1);
    }

    public ImmutableRect2i getArea() {
        return this.area;
    }

    public int getRecipeCatalystExtraWidth() {
        if (this.recipeCatalysts.isEmpty()) {
            return 0;
        }
        return this.recipeCatalysts.getWidth();
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25426() {
        super.method_25426();
        int xSize = 198;
        int ySize = this.clientConfig.isCenterSearchBarEnabled() ? this.field_22790 - 76 : this.field_22790 - 68;
        int extraSpace = 0;
        int maxHeight = this.clientConfig.getMaxRecipeGuiHeight();
        if (ySize > maxHeight) {
            extraSpace = ySize - maxHeight;
            ySize = maxHeight;
        }
        int guiLeft = (this.field_22789 - 198) / 2;
        int guiTop = 45 + extraSpace / 2;
        this.area = new ImmutableRect2i(guiLeft, guiTop, 198, ySize);
        int rightButtonX = guiLeft + 198 - 6 - 13;
        int leftButtonX = guiLeft + 6;
        Objects.requireNonNull(this.field_22793);
        int titleHeight = 9 + 6;
        int recipeClassButtonTop = guiTop + titleHeight - 13 + 2;
        this.nextRecipeCategory.method_46421(rightButtonX);
        this.nextRecipeCategory.method_46419(recipeClassButtonTop);
        this.previousRecipeCategory.method_46421(leftButtonX);
        this.previousRecipeCategory.method_46419(recipeClassButtonTop);
        int pageButtonTop = recipeClassButtonTop + 13 + 2;
        this.nextPage.method_46421(rightButtonX);
        this.nextPage.method_46419(pageButtonTop);
        this.previousPage.method_46421(leftButtonX);
        this.previousPage.method_46419(pageButtonTop);
        this.headerHeight = pageButtonTop + 13 - guiTop;
        this.titleArea = MathUtil.union(this.previousRecipeCategory.getArea(), this.nextRecipeCategory.getArea()).cropLeft(this.previousRecipeCategory.method_25368() + 14).cropRight(this.nextRecipeCategory.method_25368() + 14);
        this.method_37063((class_364)this.nextRecipeCategory);
        this.method_37063((class_364)this.previousRecipeCategory);
        this.method_37063((class_364)this.nextPage);
        this.method_37063((class_364)this.previousPage);
        this.init = true;
        this.updateLayout();
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.field_22787 == null) {
            return;
        }
        this.method_25420(poseStack);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = this.area.getX();
        int y = this.area.getY();
        int width = this.area.getWidth();
        int height = this.area.getHeight();
        this.background.draw(poseStack, x, y, width, height);
        RenderSystem.disableBlend();
        RecipesGui.method_25294((class_4587)poseStack, (int)(x + 6 + 13), (int)this.nextRecipeCategory.method_46427(), (int)(x + width - 6 - 13), (int)(this.nextRecipeCategory.method_46427() + 13), (int)0x30000000);
        RecipesGui.method_25294((class_4587)poseStack, (int)(x + 6 + 13), (int)this.nextPage.method_46427(), (int)(x + width - 6 - 13), (int)(this.nextPage.method_46427() + 13), (int)0x30000000);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RecipesGui.drawCenteredStringWithShadow(poseStack, this.field_22793, this.title, this.titleArea);
        ImmutableRect2i pageArea = MathUtil.union(this.previousPage.getArea(), this.nextPage.getArea());
        RecipesGui.drawCenteredStringWithShadow(poseStack, this.field_22793, this.pageString, pageArea);
        this.nextRecipeCategory.method_25394(poseStack, mouseX, mouseY, partialTicks);
        this.previousRecipeCategory.method_25394(poseStack, mouseX, mouseY, partialTicks);
        this.nextPage.method_25394(poseStack, mouseX, mouseY, partialTicks);
        this.previousPage.method_25394(poseStack, mouseX, mouseY, partialTicks);
        Optional<IRecipeLayoutDrawable<?>> hoveredRecipeLayout = this.drawLayouts(poseStack, mouseX, mouseY);
        Optional<IRecipeSlotDrawable> hoveredRecipeCatalyst = this.recipeCatalysts.draw(poseStack, mouseX, mouseY);
        this.recipeGuiTabs.draw(this.field_22787, poseStack, mouseX, mouseY, this.modIdHelper);
        for (RecipeTransferButton button : this.recipeTransferButtons) {
            button.drawToolTip(poseStack, mouseX, mouseY);
        }
        RenderSystem.disableBlend();
        hoveredRecipeLayout.ifPresent(l -> l.drawOverlays(poseStack, mouseX, mouseY));
        hoveredRecipeCatalyst.ifPresent(h -> h.drawHoverOverlays(poseStack));
        hoveredRecipeCatalyst.ifPresent(h -> h.getDisplayedIngredient().ifPresent(i -> {
            List<class_2561> tooltip = h.getTooltip();
            tooltip = this.modIdHelper.addModNameToIngredientTooltip(tooltip, i);
            TooltipRenderer.drawHoveringText(poseStack, tooltip, mouseX, mouseY, i, this.ingredientManager);
        }));
        RenderSystem.enableDepthTest();
        if (this.titleStringArea.contains(mouseX, mouseY) && !this.logic.hasAllCategories()) {
            class_5250 showAllRecipesString = class_2561.method_43471((String)"jei.tooltip.show.all.recipes");
            TooltipRenderer.drawHoveringText(poseStack, List.of(showAllRecipesString), mouseX, mouseY);
        }
    }

    private Optional<IRecipeLayoutDrawable<?>> drawLayouts(class_4587 poseStack, int mouseX, int mouseY) {
        IRecipeLayoutDrawable<?> hoveredLayout = null;
        for (IRecipeLayoutDrawable<?> recipeLayout : this.recipeLayouts) {
            if (recipeLayout.isMouseOver(mouseX, mouseY)) {
                hoveredLayout = recipeLayout;
            }
            recipeLayout.drawRecipe(poseStack, mouseX, mouseY);
        }
        class_310 minecraft = class_310.method_1551();
        float partialTicks = minecraft.method_1488();
        for (RecipeTransferButton button : this.recipeTransferButtons) {
            button.method_25394(poseStack, mouseX, mouseY, partialTicks);
        }
        RenderSystem.disableBlend();
        return Optional.ofNullable(hoveredLayout);
    }

    public void method_25393() {
        super.method_25393();
        Optional.ofNullable(this.field_22787).map(minecraft -> minecraft.field_1724).ifPresent(localPlayer -> {
            class_1703 container = this.getParentContainer().orElse(null);
            List<RecipeTransferButton> transferButtons = this.recipeTransferButtons;
            for (int i = 0; i < transferButtons.size(); ++i) {
                IRecipeLayoutDrawable<?> recipeLayout = this.recipeLayouts.get(i);
                RecipeTransferButton button = transferButtons.get(i);
                class_768 buttonArea = recipeLayout.getRecipeTransferButtonArea();
                button.update(buttonArea, this.recipeTransferManager, container, (class_1657)localPlayer);
            }
        });
    }

    public boolean method_25405(double mouseX, double mouseY) {
        if (this.field_22787 != null && this.field_22787.field_1755 == this) {
            if (this.area.contains(mouseX, mouseY)) {
                return true;
            }
            for (IRecipeLayoutDrawable<?> recipeLayout : this.recipeLayouts) {
                if (!recipeLayout.isMouseOver(mouseX, mouseY)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Stream<IClickableIngredientInternal<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.isOpen()) {
            return Stream.concat(this.recipeCatalysts.getIngredientUnderMouse(mouseX, mouseY), this.getRecipeLayoutsIngredientUnderMouse(mouseX, mouseY));
        }
        return Stream.empty();
    }

    private Stream<IClickableIngredientInternal<?>> getRecipeLayoutsIngredientUnderMouse(double mouseX, double mouseY) {
        return this.recipeLayouts.stream().map(recipeLayout -> RecipesGui.getRecipeLayoutIngredientUnderMouse(recipeLayout, mouseX, mouseY)).flatMap(Optional::stream);
    }

    private static Optional<IClickableIngredientInternal<?>> getRecipeLayoutIngredientUnderMouse(IRecipeLayoutDrawable<?> recipeLayout, double mouseX, double mouseY) {
        return recipeLayout.getRecipeSlotUnderMouse(mouseX, mouseY).flatMap(recipeSlot -> RecipesGui.getClickedIngredient(recipeLayout, recipeSlot));
    }

    private static Optional<IClickableIngredientInternal<?>> getClickedIngredient(IRecipeLayoutDrawable<?> recipeLayout, IRecipeSlotDrawable recipeSlot) {
        return recipeSlot.getDisplayedIngredient().map(displayedIngredient -> {
            ImmutableRect2i area = RecipesGui.absoluteClickedArea(recipeLayout, recipeSlot.getRect());
            return new ClickableIngredientInternal(displayedIngredient, area, false, true);
        });
    }

    private static ImmutableRect2i absoluteClickedArea(IRecipeLayoutDrawable<?> recipeLayout, class_768 area) {
        class_768 layoutArea = recipeLayout.getRect();
        return new ImmutableRect2i(area.method_3321() + layoutArea.method_3321(), area.method_3322() + layoutArea.method_3322(), area.method_3319(), area.hashCode());
    }

    public boolean method_25401(double scrollX, double scrollY, double scrollDelta) {
        double y;
        double x = MouseUtil.getX();
        if (this.method_25405(x, y = MouseUtil.getY())) {
            if (scrollDelta < 0.0) {
                this.logic.nextPage();
                return true;
            }
            if (scrollDelta > 0.0) {
                this.logic.previousPage();
                return true;
            }
        }
        return super.method_25401(scrollX, scrollY, scrollDelta);
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        boolean handled = UserInput.fromVanilla(mouseX, mouseY, mouseButton, InputType.IMMEDIATE).map(this::handleInput).orElse(false);
        if (handled) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        UserInput input = UserInput.fromVanilla(keyCode, scanCode, modifiers, InputType.IMMEDIATE);
        return this.handleInput(input);
    }

    private boolean handleInput(UserInput input) {
        IUserInputHandler handler;
        double mouseY;
        double mouseX = input.getMouseX();
        if (this.method_25405(mouseX, mouseY = input.getMouseY())) {
            if (this.titleStringArea.contains(mouseX, mouseY)) {
                if (input.is(this.keyBindings.getLeftClick()) && this.logic.setCategoryFocus()) {
                    return true;
                }
            } else {
                for (IRecipeLayoutDrawable<?> recipeLayout : this.recipeLayouts) {
                    if (!this.handleRecipeLayoutInput(recipeLayout, input)) continue;
                    return true;
                }
            }
        }
        if ((handler = this.recipeGuiTabs.getInputHandler()).handleUserInput(this, input, this.keyBindings).isPresent()) {
            return true;
        }
        class_310 minecraft = class_310.method_1551();
        if (input.is(this.keyBindings.getCloseRecipeGui()) || input.is(minecraft.field_1690.field_1822)) {
            this.method_25419();
            return true;
        }
        if (input.is(this.keyBindings.getRecipeBack())) {
            this.back();
            return true;
        }
        if (input.is(this.keyBindings.getNextCategory())) {
            this.logic.nextRecipeCategory();
            return true;
        }
        if (input.is(this.keyBindings.getPreviousCategory())) {
            this.logic.previousRecipeCategory();
            return true;
        }
        if (input.is(this.keyBindings.getNextRecipePage())) {
            this.logic.nextPage();
            return true;
        }
        if (input.is(this.keyBindings.getPreviousRecipePage())) {
            this.logic.previousPage();
            return true;
        }
        return false;
    }

    private <R> boolean handleRecipeLayoutInput(IRecipeLayoutDrawable<R> recipeLayout, UserInput input) {
        if (!this.method_25405(input.getMouseX(), input.getMouseY())) {
            return false;
        }
        class_768 recipeArea = recipeLayout.getRect();
        double recipeMouseX = input.getMouseX() - (double)recipeArea.method_3321();
        double recipeMouseY = input.getMouseY() - (double)recipeArea.method_3322();
        R recipe = recipeLayout.getRecipe();
        IRecipeCategory<R> recipeCategory = recipeLayout.getRecipeCategory();
        if (recipeCategory.handleInput(recipe, recipeMouseX, recipeMouseY, input.getKey())) {
            return true;
        }
        if (input.is(this.keyBindings.getCopyRecipeId())) {
            return this.handleCopyRecipeId(recipeLayout);
        }
        return false;
    }

    private <R> boolean handleCopyRecipeId(IRecipeLayoutDrawable<R> recipeLayout) {
        R recipe;
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        IRecipeCategory<R> recipeCategory = recipeLayout.getRecipeCategory();
        class_2960 registryName = recipeCategory.getRegistryName(recipe = recipeLayout.getRecipe());
        if (registryName == null) {
            class_5250 message = class_2561.method_43471((String)"jei.message.copy.recipe.id.failure");
            if (player != null) {
                player.method_7353((class_2561)message, false);
            }
            return false;
        }
        String recipeId = registryName.toString();
        minecraft.field_1774.method_1455(recipeId);
        class_5250 message = class_2561.method_43469((String)"jei.message.copy.recipe.id.success", (Object[])new Object[]{recipeId});
        if (player != null) {
            player.method_7353((class_2561)message, false);
        }
        return true;
    }

    public boolean isOpen() {
        return this.field_22787 != null && this.field_22787.field_1755 == this;
    }

    private void open() {
        if (this.field_22787 != null) {
            if (!this.isOpen()) {
                this.parentScreen = this.field_22787.field_1755;
            }
            this.field_22787.method_1507((class_437)this);
        }
    }

    public void method_25419() {
        if (this.isOpen() && this.field_22787 != null) {
            this.field_22787.method_1507(this.parentScreen);
            this.parentScreen = null;
            this.logic.clearHistory();
            return;
        }
        super.method_25419();
    }

    @Override
    public void show(List<IFocus<?>> focuses) {
        IFocusGroup checkedFocuses = this.focusFactory.createFocusGroup(focuses);
        if (this.logic.setFocus(checkedFocuses)) {
            this.open();
        }
    }

    @Override
    public void showTypes(List<RecipeType<?>> recipeTypes) {
        ErrorUtil.checkNotEmpty(recipeTypes, "recipeTypes");
        if (this.logic.setCategoryFocus(recipeTypes)) {
            this.open();
        }
    }

    @Override
    public <T> Optional<T> getIngredientUnderMouse(IIngredientType<T> ingredientType) {
        double x = MouseUtil.getX();
        double y = MouseUtil.getY();
        return this.getIngredientUnderMouse(x, y).map(IClickableIngredientInternal::getTypedIngredient).flatMap(i -> i.getIngredient(ingredientType).stream()).findFirst();
    }

    public void back() {
        this.logic.back();
    }

    private void updateLayout() {
        int heightPerRecipe;
        if (!this.init) {
            return;
        }
        IRecipeCategory<?> recipeCategory = this.logic.getSelectedRecipeCategory();
        int x = this.area.getX();
        int y = this.area.getY();
        int width = this.area.getWidth();
        int height = this.area.getHeight();
        int availableHeight = height - this.headerHeight;
        int recipesPerPage = availableHeight / (heightPerRecipe = recipeCategory.getHeight() + 14);
        if (recipesPerPage == 0) {
            availableHeight = heightPerRecipe;
            recipesPerPage = 1;
        }
        this.logic.setRecipesPerPage(recipesPerPage);
        this.title = StringUtil.stripStyling(recipeCategory.getTitle());
        int availableTitleWidth = this.titleArea.getWidth();
        if (this.field_22793.method_27525((class_5348)this.title) > availableTitleWidth) {
            this.title = StringUtil.truncateStringToWidth(this.title, availableTitleWidth, this.field_22793);
        }
        this.titleStringArea = MathUtil.centerTextArea(this.titleArea, this.field_22793, (class_5348)this.title);
        this.recipeLayouts.clear();
        int recipeXOffset = x + (width - recipeCategory.getWidth()) / 2;
        int recipeSpacing = (availableHeight - recipesPerPage * recipeCategory.getHeight()) / (recipesPerPage + 1);
        int spacingY = recipeCategory.getHeight() + recipeSpacing;
        int recipeYOffset = y + this.headerHeight + recipeSpacing;
        for (IRecipeLayoutDrawable<?> recipeLayout : this.logic.getRecipeLayouts()) {
            recipeLayout.setPosition(recipeXOffset, recipeYOffset);
            recipeYOffset += spacingY;
            this.recipeLayouts.add(recipeLayout);
        }
        this.addRecipeTransferButtons(this.recipeLayouts);
        this.nextPage.field_22763 = this.previousPage.field_22763 = this.logic.hasMultiplePages();
        this.nextRecipeCategory.field_22763 = this.previousRecipeCategory.field_22763 = this.logic.hasMultipleCategories();
        this.pageString = this.logic.getPageString();
        List<ITypedIngredient<?>> recipeCatalystIngredients = this.logic.getRecipeCatalysts().toList();
        this.recipeCatalysts.updateLayout(recipeCatalystIngredients, this.area);
        this.recipeGuiTabs.initLayout(this.area);
    }

    private void addRecipeTransferButtons(List<IRecipeLayoutDrawable<?>> recipeLayouts) {
        if (this.field_22787 == null) {
            return;
        }
        class_746 player = this.field_22787.field_1724;
        if (player == null) {
            return;
        }
        for (class_364 class_3642 : this.recipeTransferButtons) {
            this.method_37066(class_3642);
        }
        this.recipeTransferButtons.clear();
        class_1703 container = this.getParentContainer().orElse(null);
        recipeLayouts.forEach(arg_0 -> this.lambda$addRecipeTransferButtons$14(container, (class_1657)player, arg_0));
    }

    private Optional<class_1703> getParentContainer() {
        class_437 class_4372 = this.parentScreen;
        if (class_4372 instanceof class_465) {
            class_465 screen = (class_465)class_4372;
            class_1703 menu = screen.method_17577();
            return Optional.of(menu);
        }
        return Optional.empty();
    }

    @Override
    public void onStateChange() {
        this.updateLayout();
    }

    @Nullable
    public IGuiProperties getProperties() {
        if (this.field_22789 <= 0 || this.field_22790 <= 0) {
            return null;
        }
        int extraWidth = this.getRecipeCatalystExtraWidth();
        ImmutableRect2i recipeArea = this.getArea();
        int guiXSize = recipeArea.getWidth() + extraWidth;
        int guiYSize = recipeArea.getHeight();
        if (guiXSize <= 0 || guiYSize <= 0) {
            return null;
        }
        return new GuiProperties(this.getClass(), recipeArea.getX() - extraWidth, recipeArea.getY(), guiXSize, guiYSize, this.field_22789, this.field_22790);
    }

    private /* synthetic */ void lambda$addRecipeTransferButtons$14(class_1703 container, class_1657 player, IRecipeLayoutDrawable recipeLayout) {
        class_768 buttonArea = recipeLayout.getRecipeTransferButtonArea();
        IDrawableStatic icon = this.textures.getRecipeTransfer();
        RecipeTransferButton button = new RecipeTransferButton(icon, recipeLayout, this.textures, this::method_25419);
        button.update(buttonArea, this.recipeTransferManager, container, player);
        this.method_37063((class_364)button);
        this.recipeTransferButtons.add(button);
    }
}

