/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.configured.api.IAllowedEnums;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.screen.ConfigScreen;
import com.mrcrayfish.configured.client.screen.IBackgroundTexture;
import com.mrcrayfish.configured.client.screen.IEditing;
import com.mrcrayfish.configured.client.screen.ILabelProvider;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.screen.TooltipScreen;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ChangeEnumScreen
extends TooltipScreen
implements IBackgroundTexture,
IEditing {
    private final Screen parent;
    private final IModConfig config;
    private final Consumer<Enum<?>> onSave;
    private final ResourceLocation background;
    private final IConfigValue<Enum<?>> holder;
    private Enum<?> selectedValue;
    private EnumList list;
    private List<Entry> entries;
    private EditBox searchTextField;

    protected ChangeEnumScreen(Screen parent, IModConfig config, Component title, ResourceLocation background, Enum<?> value, IConfigValue<Enum<?>> holder, Consumer<Enum<?>> onSave) {
        super(title);
        this.parent = parent;
        this.config = config;
        this.onSave = onSave;
        this.background = background;
        this.holder = holder;
        this.selectedValue = value;
    }

    protected void m_7856_() {
        this.constructEntries();
        this.list = new EnumList(this.entries);
        this.list.m_93488_(!ConfigHelper.isPlayingGame());
        this.list.m_6987_((AbstractSelectionList.Entry)((Entry)this.list.m_6702_().stream().filter(entry -> entry.getEnumValue() == this.selectedValue).findFirst().orElse(null)));
        this.m_7787_((GuiEventListener)this.list);
        this.searchTextField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 110, 22, 220, 20, (Component)Component.m_237115_((String)"configured.gui.search"));
        this.searchTextField.m_94151_(s -> {
            ScreenUtil.updateSearchTextFieldSuggestion(this.searchTextField, s, this.entries);
            this.list.m_5988_(s.isEmpty() ? this.entries : (Collection)this.entries.stream().filter(entry -> entry.getFormattedLabel().getString().toLowerCase(Locale.ENGLISH).contains(s.toLowerCase(Locale.ENGLISH))).collect(Collectors.toList()));
            if (!s.isEmpty()) {
                this.list.m_93410_(0.0);
            }
        });
        this.m_7787_((GuiEventListener)this.searchTextField);
        ScreenUtil.updateSearchTextFieldSuggestion(this.searchTextField, "", this.entries);
        if (!this.config.isReadOnly()) {
            this.m_142416_((GuiEventListener)ScreenUtil.button(this.f_96543_ / 2 - 155, this.f_96544_ - 29, 150, 20, CommonComponents.f_130655_, btn -> {
                if (this.list.m_93511_() != null) {
                    this.onSave.accept(((Entry)this.list.m_93511_()).enumValue);
                }
                this.f_96541_.m_91152_(this.parent);
            }));
        }
        int cancelOffset = this.config.isReadOnly() ? -75 : 5;
        Component cancelLabel = this.config.isReadOnly() ? CommonComponents.f_130660_ : CommonComponents.f_130656_;
        this.m_142416_((GuiEventListener)ScreenUtil.button(this.f_96543_ / 2 + cancelOffset, this.f_96544_ - 29, 150, 20, cancelLabel, button -> this.f_96541_.m_91152_(this.parent)));
    }

    private void constructEntries() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        if (this.holder instanceof IAllowedEnums) {
            ((IAllowedEnums)((Object)this.holder)).getAllowedValues().forEach(e -> entries.add(new Entry((Enum)e)));
        } else {
            Enum<?> value = this.selectedValue;
            if (value != null) {
                ?[] enums;
                for (Object e2 : enums = value.getDeclaringClass().getEnumConstants()) {
                    entries.add(new Entry((Enum)e2));
                }
            }
        }
        entries.sort(Comparator.comparing(entry -> entry.getFormattedLabel().getString()));
        this.entries = ImmutableList.copyOf(entries);
    }

    public void m_86412_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        this.list.m_86412_(poseStack, mouseX, mouseY, partialTicks);
        this.searchTextField.m_86412_(poseStack, mouseX, mouseY, partialTicks);
        ChangeEnumScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)7, (int)0xFFFFFF);
        super.m_86412_(poseStack, mouseX, mouseY, partialTicks);
        RenderSystem.m_157456_((int)0, (ResourceLocation)ListMenuScreen.CONFIGURED_LOGO);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ChangeEnumScreen.m_93143_((PoseStack)poseStack, (int)10, (int)13, (int)0, (float)0.0f, (float)0.0f, (int)23, (int)23, (int)32, (int)32);
        if (ScreenUtil.isMouseWithin(10, 13, 23, 23, mouseX, mouseY)) {
            this.setActiveTooltip((Component)Component.m_237115_((String)"configured.gui.info"));
        }
        this.drawTooltip(poseStack, mouseX, mouseY);
    }

    @Override
    public IModConfig getActiveConfig() {
        return this.config;
    }

    @Override
    public ResourceLocation getBackgroundTexture() {
        return this.background;
    }

    public class EnumList
    extends AbstractSelectionList<Entry>
    implements IBackgroundTexture {
        public EnumList(List<Entry> entries) {
            super(ChangeEnumScreen.this.f_96541_, ChangeEnumScreen.this.f_96543_, ChangeEnumScreen.this.f_96544_, 50, ChangeEnumScreen.this.f_96544_ - 36, 20);
            entries.forEach(x$0 -> this.m_7085_((AbstractSelectionList.Entry)x$0));
        }

        public void m_5988_(Collection<Entry> entries) {
            super.m_5988_(entries);
        }

        @Override
        public ResourceLocation getBackgroundTexture() {
            return ChangeEnumScreen.this.background;
        }

        public void m_142291_(NarrationElementOutput output) {
            if (this.m_93511_() != null) {
                output.m_169146_(NarratedElementType.TITLE, ((Entry)this.m_93511_()).label);
            }
        }

        public boolean m_5953_(double mouseX, double mouseY) {
            if (ChangeEnumScreen.this.config.isReadOnly()) {
                return false;
            }
            return super.m_5953_(mouseX, mouseY);
        }
    }

    public class Entry
    extends ObjectSelectionList.Entry<Entry>
    implements ILabelProvider {
        private final Enum<?> enumValue;
        private final Component label;

        public Entry(Enum<?> enumValue) {
            this.enumValue = enumValue;
            this.label = Component.m_237113_((String)ConfigScreen.createLabel(enumValue.name().toLowerCase(Locale.ENGLISH)));
        }

        public Enum<?> getEnumValue() {
            return this.enumValue;
        }

        @Override
        public String getLabel() {
            return this.label.getString();
        }

        public Component getFormattedLabel() {
            return this.label;
        }

        public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            MutableComponent label = Component.m_237113_((String)this.label.getString()).m_130940_(ChangeEnumScreen.this.list.m_93511_() == this ? ChatFormatting.YELLOW : ChatFormatting.WHITE);
            Screen.m_93243_((PoseStack)poseStack, (Font)((ChangeEnumScreen)ChangeEnumScreen.this).f_96541_.f_91062_, (Component)label, (int)(left + 5), (int)(top + 4), (int)0xFFFFFF);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            ChangeEnumScreen.this.list.m_6987_((AbstractSelectionList.Entry)this);
            ChangeEnumScreen.this.selectedValue = this.enumValue;
            return true;
        }

        public Component m_142172_() {
            return this.label;
        }
    }
}

