/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.screen.ConfirmationScreen;
import com.mrcrayfish.configured.client.screen.IBackgroundTexture;
import com.mrcrayfish.configured.client.screen.IEditing;
import com.mrcrayfish.configured.client.screen.TooltipScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class EditStringScreen
extends TooltipScreen
implements IBackgroundTexture,
IEditing {
    private final Screen parent;
    private final IModConfig config;
    private final ResourceLocation background;
    private final String originalValue;
    private final Function<String, Pair<Boolean, Component>> validator;
    private final Consumer<String> onSave;
    private Button doneButton;
    private EditBox textField;
    private Component validationHint;
    private String value;

    protected EditStringScreen(Screen parent, IModConfig config, ResourceLocation background, Component component, String originalValue, Function<String, Pair<Boolean, Component>> validator, Consumer<String> onSave) {
        super(component);
        this.parent = parent;
        this.config = config;
        this.background = background;
        this.originalValue = originalValue;
        this.validator = validator;
        this.onSave = onSave;
        this.value = this.originalValue;
    }

    protected void m_7856_() {
        this.textField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 130, this.f_96544_ / 2 - 25, 260, 20, CommonComponents.f_237098_);
        this.textField.m_94199_(32500);
        this.textField.m_94144_(this.value);
        this.textField.m_94151_(s -> {
            this.value = s;
            this.updateValidation();
        });
        this.textField.m_94186_(!this.config.isReadOnly());
        this.m_142416_((GuiEventListener)this.textField);
        this.doneButton = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_96543_ / 2 - 1 - 130, this.f_96544_ / 2 + 13, 0, 44, 128, (Component)Component.m_237115_((String)"configured.gui.apply"), button -> {
            String text = this.textField.m_94155_();
            if (((Boolean)this.validator.apply(text).getLeft()).booleanValue()) {
                this.onSave.accept(text);
                this.f_96541_.m_91152_(this.parent);
            }
        }));
        this.m_142416_((GuiEventListener)ScreenUtil.button(this.f_96543_ / 2 + 3, this.f_96544_ / 2 + 13, 128, 20, CommonComponents.f_130656_, button -> this.f_96541_.m_91152_(this.parent)));
        this.updateValidation();
    }

    protected void updateValidation() {
        Pair<Boolean, Component> result = this.validator.apply(this.textField.m_94155_());
        boolean valid = (Boolean)result.getLeft();
        this.doneButton.f_93623_ = !this.config.isReadOnly() && valid;
        this.textField.m_94202_(valid || this.textField.m_94155_().isEmpty() ? -1 : -65536);
        this.validationHint = !valid ? (Component)result.getRight() : null;
    }

    public void m_86412_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        boolean showValidationHint;
        this.resetTooltip();
        this.m_7333_(poseStack);
        ConfirmationScreen.drawListBackground(0.0, this.f_96543_, this.textField.m_252907_() - 10, this.textField.m_252907_() + 20 + 10);
        this.textField.m_86412_(poseStack, mouseX, mouseY, partialTicks);
        EditStringScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 50), (int)0xFFFFFF);
        boolean bl = showValidationHint = this.validationHint != null;
        if (showValidationHint) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)IconButton.ICONS);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Screen.m_93160_((PoseStack)poseStack, (int)(this.textField.m_252754_() - 20), (int)(this.textField.m_252907_() + 3), (int)16, (int)16, (float)11.0f, (float)11.0f, (int)11, (int)11, (int)64, (int)64);
            if (ScreenUtil.isMouseWithin(this.textField.m_252754_() - 20, this.textField.m_252907_() + 3, 16, 16, mouseX, mouseY)) {
                this.setActiveTooltip(this.validationHint, -1428357120);
            }
        }
        super.m_86412_(poseStack, mouseX, mouseY, partialTicks);
        this.drawTooltip(poseStack, mouseX, mouseY);
    }

    @Override
    public IModConfig getActiveConfig() {
        return this.config;
    }

    @Override
    public ResourceLocation getBackgroundTexture() {
        return this.background;
    }
}

