/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.SessionData;
import com.mrcrayfish.configured.client.screen.ConfigScreen;
import com.mrcrayfish.configured.client.screen.ConfirmationScreen;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.screen.RequestScreen;
import com.mrcrayfish.configured.client.screen.WorldSelectionScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.io.FilenameUtils;

public class ModConfigSelectionScreen
extends ListMenuScreen {
    private final Map<ConfigType, Set<IModConfig>> configMap;

    public ModConfigSelectionScreen(Screen parent, Component title, ResourceLocation background, Map<ConfigType, Set<IModConfig>> configMap) {
        super(parent, title, background, 30);
        this.configMap = configMap;
    }

    @Override
    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        Set<IModConfig> remoteConfigs;
        Set<IModConfig> localConfigs = this.getLocalConfigs();
        if (!localConfigs.isEmpty()) {
            entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem(Component.m_237115_((String)"configured.gui.title.client_configuration").getString()));
            ArrayList localEntries = new ArrayList();
            localConfigs.forEach(config -> localEntries.add(new FileItem((IModConfig)config)));
            Collections.sort(localEntries);
            entries.addAll(localEntries);
        }
        if (!((remoteConfigs = this.getRemoteConfigs()).isEmpty() || ConfigHelper.isPlayingGame() && !ConfigHelper.isConfiguredInstalledOnServer())) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (ConfigHelper.isPlayingGame() && ConfigHelper.isPlayingRemotely()) {
                if (SessionData.isLan()) {
                    entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem(Component.m_237115_((String)"configured.gui.title.server_configuration").getString()));
                    entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem((Component)Component.m_237115_((String)"configured.gui.lan_server")));
                    return;
                }
                if (!ConfigHelper.isOperator((Player)player)) {
                    return;
                }
                if (!SessionData.isDeveloper((Player)player)) {
                    entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem(Component.m_237115_((String)"configured.gui.title.server_configuration").getString()));
                    entries.add(new ListMenuScreen.MultiTextItem((Component)Component.m_237115_((String)"configured.gui.no_developer_status"), (Component)Component.m_237110_((String)"configured.gui.developer_details", (Object[])new Object[]{Component.m_237113_((String)"configured.developer.toml").m_130940_(ChatFormatting.GOLD).m_130948_(Style.f_131099_.m_131162_(Boolean.valueOf(true)))}).m_130940_(ChatFormatting.GRAY).m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"configured.gui.developer_file"))))));
                    return;
                }
            }
            entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem(Component.m_237115_((String)"configured.gui.title.server_configuration").getString()));
            ArrayList remoteEntries = new ArrayList();
            remoteConfigs.forEach(config -> remoteEntries.add(new FileItem((IModConfig)config)));
            Collections.sort(remoteEntries);
            entries.addAll(remoteEntries);
        }
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)ScreenUtil.button(this.f_96543_ / 2 - 75, this.f_96544_ - 29, 150, 20, CommonComponents.f_130660_, button -> this.f_96541_.m_91152_(this.parent)));
    }

    private Set<IModConfig> getLocalConfigs() {
        return this.configMap.entrySet().stream().filter(entry -> !((ConfigType)((Object)((Object)entry.getKey()))).isServer()).flatMap(entry -> ((Set)entry.getValue()).stream()).collect(Collectors.toSet());
    }

    private Set<IModConfig> getRemoteConfigs() {
        return this.configMap.entrySet().stream().filter(entry -> {
            ConfigType type = (ConfigType)((Object)((Object)entry.getKey()));
            return type.isServer() && type.getDist().orElse(null) != Dist.DEDICATED_SERVER;
        }).flatMap(entry -> ((Set)entry.getValue()).stream()).collect(Collectors.toSet());
    }

    public static String createLabelFromModConfig(IModConfig config) {
        if (config.getTranslationKey() != null) {
            return I18n.m_118938_((String)config.getTranslationKey(), (Object[])new Object[0]);
        }
        String fileName = config.getFileName();
        if ((fileName = fileName.replace(config.getModId() + "-", "")).endsWith(".toml")) {
            fileName = fileName.substring(0, fileName.length() - ".toml".length());
        }
        fileName = FilenameUtils.getName((String)fileName);
        fileName = ConfigScreen.createLabel(fileName);
        return fileName;
    }

    public static boolean canEditConfig(@Nullable Player player, IModConfig config) {
        return switch (config.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case ConfigType.CLIENT -> FMLEnvironment.dist.isClient();
            case ConfigType.UNIVERSAL, ConfigType.MEMORY -> true;
            case ConfigType.SERVER, ConfigType.WORLD, ConfigType.SERVER_SYNC, ConfigType.WORLD_SYNC -> {
                if (!ConfigHelper.isPlayingGame() || ConfigHelper.isRunningLocalServer() || ConfigHelper.isOperator(player) && SessionData.isDeveloper(player)) {
                    yield true;
                }
                yield false;
            }
            case ConfigType.DEDICATED_SERVER -> false;
        };
    }

    public static boolean canRestoreConfig(Player player, IModConfig config) {
        return switch (config.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case ConfigType.CLIENT, ConfigType.UNIVERSAL, ConfigType.MEMORY -> true;
            case ConfigType.SERVER, ConfigType.SERVER_SYNC -> {
                if (!ConfigHelper.isPlayingGame() || ConfigHelper.isRunningLocalServer()) {
                    yield true;
                }
                yield false;
            }
            case ConfigType.WORLD, ConfigType.WORLD_SYNC -> ConfigHelper.isRunningLocalServer();
            case ConfigType.DEDICATED_SERVER -> false;
        };
    }

    public class FileItem
    extends ListMenuScreen.Item {
        protected final IModConfig config;
        protected final Component title;
        protected final Component fileName;
        protected final Button modifyButton;
        @Nullable
        protected final Button restoreButton;

        public FileItem(IModConfig config) {
            super(ModConfigSelectionScreen.createLabelFromModConfig(config));
            this.config = config;
            this.title = this.createTrimmedFileName(ModConfigSelectionScreen.createLabelFromModConfig(config));
            this.fileName = this.createTrimmedFileName(config.getFileName()).m_130940_(ChatFormatting.DARK_GRAY);
            this.modifyButton = this.createModifyButton(config);
            this.modifyButton.f_93623_ = ModConfigSelectionScreen.canEditConfig((Player)Minecraft.m_91087_().f_91074_, config);
            this.restoreButton = this.createRestoreButton(config);
            this.updateRestoreDefaultButton();
        }

        private void showRestoreScreen() {
            ConfirmationScreen confirmScreen = new ConfirmationScreen(ModConfigSelectionScreen.this, (Component)Component.m_237115_((String)"configured.gui.restore_message"), ConfirmationScreen.Icon.WARNING, result -> {
                if (!result.booleanValue()) {
                    return true;
                }
                this.config.restoreDefaults();
                this.updateRestoreDefaultButton();
                return true;
            });
            confirmScreen.setBackground(ModConfigSelectionScreen.this.background);
            confirmScreen.setPositiveText((Component)Component.m_237115_((String)"configured.gui.restore").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
            confirmScreen.setNegativeText(CommonComponents.f_130656_);
            Minecraft.m_91087_().m_91152_((Screen)confirmScreen);
        }

        private MutableComponent createTrimmedFileName(String fileName) {
            MutableComponent trimmedFileName = Component.m_237113_((String)fileName);
            if (Minecraft.m_91087_().f_91062_.m_92895_(fileName) > 150) {
                trimmedFileName = Component.m_237113_((String)(Minecraft.m_91087_().f_91062_.m_92834_(fileName, 140) + "..."));
            }
            return trimmedFileName;
        }

        private Button createModifyButton(IModConfig config) {
            int width = ModConfigSelectionScreen.canRestoreConfig((Player)Minecraft.m_91087_().f_91074_, config) ? 60 : 82;
            return new IconButton(0, 0, this.getModifyIconU(config), this.getModifyIconV(config), width, this.getModifyLabel(config), button -> {
                if (!button.m_142518_() || !button.f_93624_) {
                    return;
                }
                if (!ConfigHelper.isPlayingGame()) {
                    if (ConfigHelper.isWorldConfig(config)) {
                        Minecraft.m_91087_().m_91152_((Screen)new WorldSelectionScreen((Screen)ModConfigSelectionScreen.this, ModConfigSelectionScreen.this.background, config, this.title));
                    } else if (config.getType() != ConfigType.DEDICATED_SERVER) {
                        MutableComponent newTitle = ModConfigSelectionScreen.this.f_96539_.m_6881_().m_7220_((Component)Component.m_237113_((String)" > ").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})).m_7220_(this.title);
                        Minecraft.m_91087_().m_91152_((Screen)new ConfigScreen((Screen)ModConfigSelectionScreen.this, (Component)newTitle, config, ModConfigSelectionScreen.this.background));
                    }
                } else if (ConfigHelper.isPlayingRemotely() && config.getType().isServer() && !config.getType().isSync()) {
                    ModList.get().getModContainerById(config.getModId()).ifPresent(container -> {
                        MutableComponent newTitle = ModConfigSelectionScreen.this.f_96539_.m_6881_().m_7220_((Component)Component.m_237113_((String)" > ").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})).m_7220_(this.title);
                        Minecraft.m_91087_().m_91152_((Screen)new RequestScreen((Screen)ModConfigSelectionScreen.this, (Component)newTitle, ModConfigSelectionScreen.this.background, config));
                    });
                } else {
                    ModList.get().getModContainerById(config.getModId()).ifPresent(container -> {
                        MutableComponent newTitle = ModConfigSelectionScreen.this.f_96539_.m_6881_().m_7220_((Component)Component.m_237113_((String)" > ").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})).m_7220_(this.title);
                        Minecraft.m_91087_().m_91152_((Screen)new ConfigScreen((Screen)ModConfigSelectionScreen.this, (Component)newTitle, config, ModConfigSelectionScreen.this.background));
                    });
                }
            });
        }

        private int getModifyIconU(IModConfig config) {
            if (ConfigHelper.isPlayingGame()) {
                if (ConfigHelper.isPlayingRemotely() && config.getType().isServer() && !config.getType().isSync()) {
                    return 22;
                }
            } else if (ConfigHelper.isWorldConfig(config)) {
                return 11;
            }
            return 0;
        }

        private int getModifyIconV(IModConfig config) {
            if (ConfigHelper.isPlayingGame()) {
                if (ConfigHelper.isPlayingRemotely() && config.getType().isServer() && !config.getType().isSync()) {
                    return 22;
                }
                if (config.isReadOnly()) {
                    return 33;
                }
            } else if (config.isReadOnly() && !ConfigHelper.isWorldConfig(config)) {
                return 33;
            }
            return 22;
        }

        private Component getModifyLabel(IModConfig config) {
            if (!ConfigHelper.isPlayingGame() && ConfigHelper.isWorldConfig(config)) {
                return Component.m_237115_((String)"configured.gui.select_world");
            }
            if (ConfigHelper.isPlayingGame() && ConfigHelper.isPlayingRemotely() && config.getType().isServer() && !config.getType().isSync() && config.getType() != ConfigType.DEDICATED_SERVER) {
                return Component.m_237115_((String)"configured.gui.request");
            }
            if (config.isReadOnly()) {
                return Component.m_237115_((String)"configured.gui.view");
            }
            return Component.m_237115_((String)"configured.gui.modify");
        }

        private Button createRestoreButton(IModConfig config) {
            if (ModConfigSelectionScreen.canRestoreConfig((Player)Minecraft.m_91087_().f_91074_, config)) {
                IconButton restoreButton = new IconButton(0, 0, 0, 0, onPress -> this.showRestoreScreen());
                restoreButton.f_93623_ = !config.isReadOnly() && ConfigHelper.hasPermissionToEdit((Player)Minecraft.m_91087_().f_91074_, config);
                return restoreButton;
            }
            return null;
        }

        @Override
        public void m_6311_(PoseStack poseStack, int x, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
            Screen.m_93243_((PoseStack)poseStack, (Font)Minecraft.m_91087_().f_91062_, (Component)this.title, (int)(left + 28), (int)(top + 2), (int)0xFFFFFF);
            Screen.m_93243_((PoseStack)poseStack, (Font)Minecraft.m_91087_().f_91062_, (Component)this.fileName, (int)(left + 28), (int)(top + 12), (int)0xFFFFFF);
            RenderSystem.m_157456_((int)0, (ResourceLocation)IconButton.ICONS);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiComponent.m_93160_((PoseStack)poseStack, (int)(left + 4), (int)top, (int)18, (int)22, (float)this.getIconU(), (float)this.getIconV(), (int)9, (int)11, (int)64, (int)64);
            if (this.config.isReadOnly()) {
                GuiComponent.m_93160_((PoseStack)poseStack, (int)(left + 1), (int)(top + 15), (int)11, (int)11, (float)0.0f, (float)33.0f, (int)11, (int)11, (int)64, (int)64);
            }
            this.modifyButton.m_252865_(left + width - 83);
            this.modifyButton.m_253211_(top);
            this.modifyButton.m_86412_(poseStack, mouseX, mouseY, partialTicks);
            if (this.restoreButton != null) {
                this.restoreButton.m_252865_(left + width - 21);
                this.restoreButton.m_253211_(top);
                this.restoreButton.m_86412_(poseStack, mouseX, mouseY, partialTicks);
            }
            if (this.config.isReadOnly() && ScreenUtil.isMouseWithin(left - 1, top + 15, 11, 11, mouseX, mouseY)) {
                ModConfigSelectionScreen.this.setActiveTooltip((Component)Component.m_237115_((String)"configured.gui.read_only_config"), -14785178);
            }
        }

        private int getIconU() {
            return this.config.getType().ordinal() % 3 * 9 + 33;
        }

        private int getIconV() {
            return this.config.getType().ordinal() / 3 * 11;
        }

        @Override
        public List<? extends GuiEventListener> m_6702_() {
            if (this.restoreButton != null) {
                return ImmutableList.of((Object)this.modifyButton, (Object)this.restoreButton);
            }
            return ImmutableList.of((Object)this.modifyButton);
        }

        private void updateRestoreDefaultButton() {
            if (this.config != null && this.restoreButton != null && ModConfigSelectionScreen.canRestoreConfig((Player)Minecraft.m_91087_().f_91074_, this.config)) {
                this.restoreButton.f_93623_ = !this.config.isReadOnly() && this.config.isChanged();
            }
        }
    }
}

