/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.util;

import com.electronwill.nightconfig.core.AbstractConfig;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.file.FileWatcher;
import com.electronwill.nightconfig.core.utils.UnmodifiableConfigWrapper;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.google.common.collect.ImmutableList;
import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.network.PacketHandler;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.IConfigEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHelper {
    private static final Set<Path> WATCHED_PATHS = new HashSet<Path>();
    private static final Method MOD_CONFIG_SET_CONFIG_DATA = ObfuscationReflectionHelper.findMethod(ModConfig.class, (String)"setConfigData", (Class[])new Class[]{CommentedConfig.class});
    private static final Method MOD_CONFIG_FIRE_EVENT = ObfuscationReflectionHelper.findMethod(ModConfig.class, (String)"fireEvent", (Class[])new Class[]{IConfigEvent.class});

    public static List<IConfigEntry> gatherAllConfigEntries(IConfigEntry entry) {
        ObjectArrayList entries = new ObjectArrayList();
        ArrayDeque<IConfigEntry> queue = new ArrayDeque<IConfigEntry>(entry.getChildren());
        while (!queue.isEmpty()) {
            IConfigEntry e = (IConfigEntry)queue.poll();
            entries.add(e);
            if (e.isLeaf()) continue;
            queue.addAll(e.getChildren());
        }
        return entries;
    }

    public static List<IConfigValue<?>> gatherAllConfigValues(IModConfig config) {
        return ConfigHelper.gatherAllConfigValues(config.getRoot());
    }

    public static List<IConfigValue<?>> gatherAllConfigValues(IConfigEntry entry) {
        ObjectArrayList values = new ObjectArrayList();
        ConfigHelper.gatherValuesFromForgeConfig(entry, values);
        return ImmutableList.copyOf((Collection)values);
    }

    private static void gatherValuesFromForgeConfig(IConfigEntry entry, List<IConfigValue<?>> values) {
        if (entry.isLeaf()) {
            IConfigValue<?> value = entry.getValue();
            if (value != null) {
                values.add(value);
            }
            return;
        }
        for (IConfigEntry children : entry.getChildren()) {
            ConfigHelper.gatherValuesFromForgeConfig(children, values);
        }
    }

    public static List<Pair<ForgeConfigSpec.ConfigValue<?>, ForgeConfigSpec.ValueSpec>> gatherAllForgeConfigValues(UnmodifiableConfig config, UnmodifiableConfig spec) {
        ArrayList values = new ArrayList();
        ConfigHelper.gatherValuesFromForgeConfig(config, spec, values);
        return ImmutableList.copyOf(values);
    }

    private static void gatherValuesFromForgeConfig(UnmodifiableConfig config, UnmodifiableConfig spec, List<Pair<ForgeConfigSpec.ConfigValue<?>, ForgeConfigSpec.ValueSpec>> values) {
        config.valueMap().forEach((s, o) -> {
            if (o instanceof AbstractConfig) {
                ConfigHelper.gatherValuesFromForgeConfig((UnmodifiableConfig)o, spec, values);
            } else if (o instanceof ForgeConfigSpec.ConfigValue) {
                ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)o;
                ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)spec.getRaw(configValue.getPath());
                values.add(Pair.of((Object)configValue, (Object)valueSpec));
            }
        });
    }

    public static void setForgeConfigData(ModConfig config, @Nullable CommentedConfig configData) {
        try {
            MOD_CONFIG_SET_CONFIG_DATA.invoke((Object)config, configData);
            if (configData instanceof FileConfig) {
                config.save();
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static ModConfig getForgeConfig(String fileName) {
        return (ModConfig)ConfigTracker.INSTANCE.fileMap().get(fileName);
    }

    public static void fireForgeConfigEvent(ModConfig config, ModConfigEvent event) {
        try {
            MOD_CONFIG_FIRE_EVENT.invoke((Object)config, event);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static boolean isWorldConfig(IModConfig config) {
        return config.getType() == ConfigType.WORLD || config.getType() == ConfigType.WORLD_SYNC;
    }

    public static boolean isServerConfig(IModConfig config) {
        return config.getType().isServer() && !ConfigHelper.isWorldConfig(config);
    }

    public static boolean isConfiguredInstalledOnServer() {
        ClientPacketListener listener = Minecraft.m_91087_().m_91403_();
        return listener != null && PacketHandler.getPlayChannel().isRemotePresent(listener.m_104910_());
    }

    public static Set<IConfigValue<?>> getChangedValues(IConfigEntry entry) {
        HashSet changed = new HashSet();
        ArrayDeque<IConfigEntry> found = new ArrayDeque<IConfigEntry>();
        found.add(entry);
        while (!found.isEmpty()) {
            IConfigEntry toSave = (IConfigEntry)found.poll();
            if (!toSave.isLeaf()) {
                found.addAll(toSave.getChildren());
                continue;
            }
            IConfigValue<?> value = toSave.getValue();
            if (value == null || !value.isChanged()) continue;
            changed.add(value);
        }
        return changed;
    }

    public static boolean isPlayingGame() {
        return FMLEnvironment.dist.isDedicatedServer() || (Boolean)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().f_91073_ != null) != false;
    }

    public static boolean isServerOwnedByPlayer(@Nullable Player player) {
        return player != null && player.m_20194_() != null && !player.m_20194_().m_6982_() && player.m_20194_().m_7779_(player.m_36316_());
    }

    public static boolean hasPermissionToEdit(@Nullable Player player, IModConfig config) {
        return !config.getType().isServer() || player != null && (player.m_20310_(4) || ConfigHelper.isServerOwnedByPlayer(player));
    }

    public static boolean isOperator(@Nullable Player player) {
        return player != null && player.m_20310_(4);
    }

    public static boolean isRunningLocalServer() {
        return FMLEnvironment.dist.isClient() && (Boolean)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().m_91091_()) != false;
    }

    public static boolean isPlayingLocally() {
        return FMLEnvironment.dist.isClient() && (Boolean)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().m_91092_() != null) != false;
    }

    public static boolean isPlayingRemotely() {
        return FMLEnvironment.dist.isClient() && (Boolean)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ClientPacketListener listener = Minecraft.m_91087_().m_91403_();
            return listener != null && !listener.m_104910_().m_129531_();
        }) != false;
    }

    @Nullable
    public static Player getClientPlayer() {
        return !FMLEnvironment.dist.isClient() ? null : (Player)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().f_91074_);
    }

    public static void createBackup(UnmodifiableConfig config) {
        if (config instanceof FileConfig) {
            FileConfig fileConfig = (FileConfig)config;
            try {
                Path configPath = fileConfig.getNioPath();
                if (Files.exists(configPath, new LinkOption[0]) && fileConfig.getFile().length() > 0L) {
                    Path backupPath = configPath.getParent().resolve(fileConfig.getFile().getName() + ".bak");
                    Files.copy(configPath, backupPath, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void closeConfig(UnmodifiableConfig config) {
        if (config instanceof FileConfig) {
            FileConfig fileConfig = (FileConfig)config;
            Path path = fileConfig.getNioPath();
            if (WATCHED_PATHS.contains(path)) {
                FileWatcher.defaultInstance().removeWatch(path);
                WATCHED_PATHS.remove(path);
            }
            fileConfig.close();
        }
    }

    public static void loadConfig(UnmodifiableConfig config) {
        if (config instanceof FileConfig) {
            FileConfig fileConfig = (FileConfig)config;
            try {
                fileConfig.load();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void saveConfig(UnmodifiableConfig config) {
        if (config instanceof FileConfig) {
            FileConfig fileConfig = (FileConfig)config;
            fileConfig.save();
        }
    }

    public static void watchConfig(UnmodifiableConfig config, Runnable callback) {
        if (config instanceof FileConfig) {
            FileConfig fileConfig = (FileConfig)config;
            try {
                Path path = fileConfig.getNioPath();
                WATCHED_PATHS.add(path);
                FileWatcher.defaultInstance().setWatch(path, callback);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static byte[] readBytes(Path path) {
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getBytes(UnmodifiableConfig config) {
        if (config instanceof FileConfig) {
            FileConfig fc = (FileConfig)config;
            return ConfigHelper.readBytes(fc.getNioPath());
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TomlFormat.instance().createWriter().write(config, (OutputStream)stream);
        return stream.toByteArray();
    }

    @Nullable
    public static ForgeConfigSpec findForgeConfigSpec(UnmodifiableConfig config) {
        if (config instanceof ForgeConfigSpec) {
            ForgeConfigSpec spec = (ForgeConfigSpec)config;
            return spec;
        }
        if (config instanceof UnmodifiableConfigWrapper) {
            try {
                Field field = UnmodifiableConfigWrapper.class.getDeclaredField("config");
                field.setAccessible(true);
                return ConfigHelper.findForgeConfigSpec(MethodHandles.lookup().unreflectGetter(field).invoke(config));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }
}

