/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.fabricmod.mixins.BiomeAccessor;
import com.mamiyaotaru.voxelmap.interfaces.AbstractMapData;
import com.mamiyaotaru.voxelmap.util.BlockModel;
import com.mamiyaotaru.voxelmap.util.BlockRepository;
import com.mamiyaotaru.voxelmap.util.ColorUtils;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.ImageUtils;
import com.mamiyaotaru.voxelmap.util.MessageUtils;
import com.mamiyaotaru.voxelmap.util.MutableBlockPos;
import com.mamiyaotaru.voxelmap.util.OpenGL;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.imageio.ImageIO;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1060;
import net.minecraft.class_1087;
import net.minecraft.class_151;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1926;
import net.minecraft.class_1933;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2457;
import net.minecraft.class_2464;
import net.minecraft.class_2478;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_315;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_3614;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_773;
import net.minecraft.class_776;
import net.minecraft.class_777;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_804;
import net.minecraft.class_809;
import net.minecraft.class_811;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class ColorManager {
    private boolean resourcePacksChanged;
    private class_638 world;
    private BufferedImage terrainBuff;
    private BufferedImage colorPicker;
    private int sizeOfBiomeArray;
    private int[] blockColors = new int[16384];
    private int[] blockColorsWithDefaultTint = new int[16384];
    private final HashSet<Integer> biomeTintsAvailable = new HashSet();
    private boolean optifineInstalled = false;
    private final HashMap<Integer, int[][]> blockTintTables = new HashMap();
    private final HashSet<Integer> biomeTextureAvailable = new HashSet();
    private final HashMap<String, Integer> blockBiomeSpecificColors = new HashMap();
    private float failedToLoadX;
    private float failedToLoadY;
    private String renderPassThreeBlendMode;
    private final class_5819 random = class_5819.method_43047();
    private boolean loaded;
    private final MutableBlockPos dummyBlockPos = new MutableBlockPos(class_2338.field_10980.method_10263(), class_2338.field_10980.method_10264(), class_2338.field_10980.method_10260());
    private final Vector3f fullbright = new Vector3f(1.0f, 1.0f, 1.0f);
    private final ColorResolver spruceColorResolver = (blockState, biomex, blockPos) -> class_1926.method_8342();
    private final ColorResolver birchColorResolver = (blockState, biomex, blockPos) -> class_1926.method_8343();
    private final ColorResolver grassColorResolver = (blockState, biomex, blockPos) -> biomex.method_8711((double)blockPos.method_10263(), (double)blockPos.method_10260());
    private final ColorResolver foliageColorResolver = (blockState, biomex, blockPos) -> biomex.method_8698();
    private final ColorResolver waterColorResolver = (blockState, biomex, blockPos) -> biomex.method_8687();
    private final ColorResolver redstoneColorResolver = (blockState, biomex, blockPos) -> class_2457.method_10487((int)((Integer)blockState.method_11654((class_2769)class_2457.field_11432)));

    public ColorManager() {
        Field ofProfiler = null;
        try {
            ofProfiler = class_315.class.getDeclaredField("ofProfiler");
        }
        catch (NoSuchFieldException | SecurityException exception) {
        }
        finally {
            if (ofProfiler != null) {
                this.optifineInstalled = true;
            }
        }
        ++this.sizeOfBiomeArray;
    }

    public int getAirColor() {
        return this.blockColors[BlockRepository.airID];
    }

    public BufferedImage getColorPicker() {
        return this.colorPicker;
    }

    public void onResourceManagerReload(class_3300 resourceManager) {
        this.resourcePacksChanged = true;
    }

    public boolean checkForChanges() {
        boolean biomesChanged = false;
        if (VoxelConstants.getClientWorld() != this.world) {
            this.world = VoxelConstants.getClientWorld();
            int largestBiomeID = 0;
            for (class_1959 biome : this.world.method_30349().method_30530(class_7924.field_41236)) {
                int biomeID = this.world.method_30349().method_30530(class_7924.field_41236).method_10206((Object)biome);
                if (biomeID <= largestBiomeID) continue;
                largestBiomeID = biomeID;
            }
            if (this.sizeOfBiomeArray != largestBiomeID + 1) {
                this.sizeOfBiomeArray = largestBiomeID + 1;
                biomesChanged = true;
            }
        }
        boolean changed = this.resourcePacksChanged || biomesChanged;
        this.resourcePacksChanged = false;
        if (changed) {
            this.loadColors();
        }
        return changed;
    }

    private void loadColors() {
        VoxelConstants.getPlayer().method_3117();
        BlockRepository.getBlocks();
        this.loadColorPicker();
        this.loadTexturePackTerrainImage();
        class_1058 missing = (class_1058)VoxelConstants.getMinecraft().method_1549(class_1723.field_21668).apply(new class_2960("missingno"));
        this.failedToLoadX = missing.method_4594();
        this.failedToLoadY = missing.method_4593();
        this.loaded = false;
        try {
            Arrays.fill(this.blockColors, -16842497);
            Arrays.fill(this.blockColorsWithDefaultTint, -16842497);
            this.loadSpecialColors();
            this.biomeTintsAvailable.clear();
            this.biomeTextureAvailable.clear();
            this.blockBiomeSpecificColors.clear();
            this.blockTintTables.clear();
            if (this.optifineInstalled) {
                try {
                    this.processCTM();
                }
                catch (Exception var4) {
                    VoxelConstants.getLogger().error("error loading CTM " + var4.getLocalizedMessage(), (Throwable)var4);
                }
                try {
                    this.processColorProperties();
                }
                catch (Exception var3) {
                    VoxelConstants.getLogger().error("error loading custom color properties " + var3.getLocalizedMessage(), (Throwable)var3);
                }
            }
            VoxelConstants.getVoxelMapInstance().getMap().forceFullRender(true);
        }
        catch (Exception var5) {
            VoxelConstants.getLogger().error("error loading pack", (Throwable)var5);
        }
        this.loaded = true;
    }

    public final BufferedImage getBlockImage(class_2680 blockState, class_1799 stack, class_1937 world, float iconScale, float captureDepth) {
        try {
            class_1087 model = VoxelConstants.getMinecraft().method_1480().method_4019(stack, world, null, 0);
            this.drawModel(class_2350.field_11034, blockState, model, stack, iconScale, captureDepth);
            BufferedImage blockImage = ImageUtils.createBufferedImageFromGLID(GLUtils.fboTextureID);
            ImageIO.write((RenderedImage)blockImage, "png", new File(VoxelConstants.getMinecraft().field_1697, blockState.method_26204().method_9518().getString() + "-" + class_2248.method_9507((class_2680)blockState) + ".png"));
            return blockImage;
        }
        catch (Exception var8) {
            VoxelConstants.getLogger().error("error getting block armor image for " + blockState.toString() + ": " + var8.getLocalizedMessage(), (Throwable)var8);
            return null;
        }
    }

    private void drawModel(class_2350 facing, class_2680 blockState, class_1087 model, class_1799 stack, float scale, float captureDepth) {
        float size = 8.0f * scale;
        class_809 transforms = model.method_4709();
        class_804 headTransforms = transforms.field_4311;
        Vector3f translations = headTransforms.field_4286;
        float transX = -translations.x() * size + 0.5f * size;
        float transY = translations.y() * size + 0.5f * size;
        float transZ = -translations.z() * size + 0.5f * size;
        Vector3f rotations = headTransforms.field_4287;
        float rotX = rotations.x();
        float rotY = rotations.y();
        float rotZ = rotations.z();
        OpenGL.glBindTexture(3553, GLUtils.fboTextureID);
        int width = OpenGL.glGetTexLevelParameteri(3553, 0, 4096);
        int height = OpenGL.glGetTexLevelParameteri(3553, 0, 4097);
        OpenGL.glBindTexture(3553, 0);
        OpenGL.glViewport(0, 0, width, height);
        Matrix4f minimapProjectionMatrix = RenderSystem.getProjectionMatrix();
        Matrix4f matrix4f = new Matrix4f().ortho(0.0f, (float)width, (float)height, 0.0f, 1000.0f, 3000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f);
        class_4587 matrixStack = RenderSystem.getModelViewStack();
        matrixStack.method_22903();
        matrixStack.method_34426();
        matrixStack.method_22904(0.0, 0.0, -3000.0 + (double)(captureDepth * scale));
        RenderSystem.applyModelViewMatrix();
        GLUtils.bindFrameBuffer();
        OpenGL.glDepthMask(true);
        OpenGL.glEnable(2929);
        OpenGL.glEnable(3042);
        OpenGL.glDisable(2884);
        OpenGL.glBlendFunc(770, 771);
        OpenGL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        OpenGL.glClearColor(1.0f, 1.0f, 1.0f, 0.0f);
        OpenGL.glClearDepth(1.0);
        OpenGL.glClear(16640);
        OpenGL.glBlendFunc(770, 771);
        matrixStack.method_22903();
        matrixStack.method_46416((float)width / 2.0f - size / 2.0f + transX, (float)height / 2.0f - size / 2.0f + transY, 0.0f + transZ);
        matrixStack.method_22905(size, size, size);
        VoxelConstants.getMinecraft().method_1531().method_4619(class_1723.field_21668).method_4527(false, false);
        GLUtils.img2(class_1723.field_21668);
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(rotY));
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(rotX));
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees(rotZ));
        if (facing == class_2350.field_11036) {
            matrixStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
        }
        RenderSystem.applyModelViewMatrix();
        Vector4f fullbright2 = new Vector4f(this.fullbright.x, this.fullbright.y, this.fullbright.z, 0.0f);
        fullbright2.mul((Matrix4fc)matrixStack.method_23760().method_23761());
        Vector3f fullbright3 = new Vector3f(fullbright2.x, fullbright2.y, fullbright2.z);
        RenderSystem.setShaderLights((Vector3f)fullbright3, (Vector3f)fullbright3);
        class_4587 newMatrixStack = new class_4587();
        class_4597.class_4598 immediate = VoxelConstants.getMinecraft().method_22940().method_23000();
        VoxelConstants.getMinecraft().method_1480().method_23179(stack, class_811.field_4315, false, newMatrixStack, (class_4597)immediate, 0xF000F0, class_4608.field_21444, model);
        immediate.method_22993();
        matrixStack.method_22909();
        matrixStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        OpenGL.glEnable(2884);
        OpenGL.glDisable(2929);
        OpenGL.glDepthMask(false);
        GLUtils.unbindFrameBuffer();
        RenderSystem.setProjectionMatrix((Matrix4f)minimapProjectionMatrix);
        OpenGL.glViewport(0, 0, VoxelConstants.getMinecraft().method_22683().method_4489(), VoxelConstants.getMinecraft().method_22683().method_4506());
    }

    private void loadColorPicker() {
        try {
            InputStream is = ((class_3298)VoxelConstants.getMinecraft().method_1478().method_14486(new class_2960("voxelmap", "images/colorpicker.png")).get()).method_14482();
            BufferedImage picker = ImageIO.read(is);
            is.close();
            this.colorPicker = new BufferedImage(((Image)picker).getWidth(null), ((Image)picker).getHeight(null), 2);
            Graphics2D gfx = this.colorPicker.createGraphics();
            gfx.drawImage((Image)picker, 0, 0, null);
            gfx.dispose();
        }
        catch (Exception var4) {
            VoxelConstants.getLogger().error("Error loading color picker: " + var4.getLocalizedMessage());
        }
    }

    public void setSkyColor(int skyColor) {
        this.blockColors[BlockRepository.airID] = skyColor;
        this.blockColors[BlockRepository.voidAirID] = skyColor;
        this.blockColors[BlockRepository.caveAirID] = skyColor;
    }

    private void loadTexturePackTerrainImage() {
        try {
            class_1060 textureManager = VoxelConstants.getMinecraft().method_1531();
            textureManager.method_22813(class_1723.field_21668);
            BufferedImage terrainStitched = ImageUtils.createBufferedImageFromCurrentGLImage();
            this.terrainBuff = new BufferedImage(terrainStitched.getWidth(null), terrainStitched.getHeight(null), 6);
            Graphics2D gfx = this.terrainBuff.createGraphics();
            gfx.drawImage((Image)terrainStitched, 0, 0, null);
            gfx.dispose();
        }
        catch (Exception var4) {
            VoxelConstants.getLogger().error("Error processing new resource pack: " + var4.getLocalizedMessage(), (Throwable)var4);
        }
    }

    private void loadSpecialColors() {
        int blockStateID;
        for (class_2680 blockState : BlockRepository.pistonTechBlock.method_9595().method_11662()) {
            blockStateID = BlockRepository.getStateId(blockState);
            this.blockColors[blockStateID] = 0;
        }
        for (class_2680 blockState : BlockRepository.barrier.method_9595().method_11662()) {
            blockStateID = BlockRepository.getStateId(blockState);
            this.blockColors[blockStateID] = 0;
        }
    }

    public final int getBlockColorWithDefaultTint(MutableBlockPos blockPos, int blockStateID) {
        if (this.loaded) {
            int col = 0x1B000000;
            try {
                col = this.blockColorsWithDefaultTint[blockStateID];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            return col != -16842497 ? col : this.getBlockColor(blockPos, blockStateID);
        }
        return 0;
    }

    public final int getBlockColor(MutableBlockPos blockPos, int blockStateID, int biomeID) {
        if (this.loaded) {
            Integer col;
            if (this.optifineInstalled && this.biomeTextureAvailable.contains(blockStateID) && (col = this.blockBiomeSpecificColors.get(blockStateID + " " + biomeID)) != null) {
                return col;
            }
            return this.getBlockColor(blockPos, blockStateID);
        }
        return 0;
    }

    private int getBlockColor(int blockStateID) {
        return this.getBlockColor(this.dummyBlockPos, blockStateID);
    }

    private int getBlockColor(MutableBlockPos blockPos, int blockStateID) {
        int col = 0x1B000000;
        try {
            col = this.blockColors[blockStateID];
        }
        catch (ArrayIndexOutOfBoundsException var5) {
            this.resizeColorArrays(blockStateID);
        }
        if (col == -16842497 || col == 0x1B000000) {
            class_2680 blockState = BlockRepository.getStateById(blockStateID);
            col = this.blockColors[blockStateID] = this.getColor(blockPos, blockState);
        }
        return col;
    }

    private synchronized void resizeColorArrays(int queriedID) {
        if (queriedID >= this.blockColors.length) {
            int[] newBlockColors = new int[this.blockColors.length * 2];
            int[] newBlockColorsWithDefaultTint = new int[this.blockColors.length * 2];
            System.arraycopy(this.blockColors, 0, newBlockColors, 0, this.blockColors.length);
            System.arraycopy(this.blockColorsWithDefaultTint, 0, newBlockColorsWithDefaultTint, 0, this.blockColorsWithDefaultTint.length);
            Arrays.fill(newBlockColors, this.blockColors.length, newBlockColors.length, -16842497);
            Arrays.fill(newBlockColorsWithDefaultTint, this.blockColorsWithDefaultTint.length, newBlockColorsWithDefaultTint.length, -16842497);
            this.blockColors = newBlockColors;
            this.blockColorsWithDefaultTint = newBlockColorsWithDefaultTint;
        }
    }

    private int getColor(MutableBlockPos blockPos, class_2680 state) {
        try {
            class_2248 block;
            int color = this.getColorForBlockPosBlockStateAndFacing(blockPos, state, class_2350.field_11036);
            if (color == 0x1B000000) {
                class_776 blockRendererDispatcher = VoxelConstants.getMinecraft().method_1541();
                color = this.getColorForTerrainSprite(state, blockRendererDispatcher);
            }
            if ((block = state.method_26204()) == BlockRepository.cobweb) {
                color |= 0xFF000000;
            }
            if (block == BlockRepository.redstone) {
                color = ColorUtils.colorMultiplier(color, VoxelConstants.getMinecraft().method_1505().method_1697(state, null, null, 0) | 0xFF000000);
            }
            if (BlockRepository.biomeBlocks.contains(block)) {
                this.applyDefaultBuiltInShading(state, color);
            } else {
                this.checkForBiomeTinting(blockPos, state, color);
            }
            if (BlockRepository.shapedBlocks.contains(block)) {
                color = this.applyShape(block, color);
            }
            if ((color >> 24 & 0xFF) < 27) {
                color |= 0x1B000000;
            }
            return color;
        }
        catch (Exception var5) {
            VoxelConstants.getLogger().error("failed getting color: " + state.method_26204().method_9518().getString(), (Throwable)var5);
            return 0x1B000000;
        }
    }

    private int getColorForBlockPosBlockStateAndFacing(class_2338 blockPos, class_2680 blockState, class_2350 facing) {
        int color = 0x1B000000;
        try {
            class_2464 blockRenderType = blockState.method_26217();
            class_776 blockRendererDispatcher = VoxelConstants.getMinecraft().method_1541();
            if (blockRenderType == class_2464.field_11458) {
                class_1087 iBakedModel = blockRendererDispatcher.method_3349(blockState);
                ArrayList<class_777> quads = new ArrayList<class_777>();
                quads.addAll(iBakedModel.method_4707(blockState, facing, this.random));
                quads.addAll(iBakedModel.method_4707(blockState, null, this.random));
                BlockModel model = new BlockModel(quads, this.failedToLoadX, this.failedToLoadY);
                if (model.numberOfFaces() > 0) {
                    BufferedImage modelImage = model.getImage(this.terrainBuff);
                    if (modelImage != null) {
                        color = this.getColorForCoordinatesAndImage(new float[]{0.0f, 1.0f, 0.0f, 1.0f}, modelImage);
                    } else {
                        VoxelConstants.getLogger().warn("image was null");
                    }
                }
            }
        }
        catch (Exception var11) {
            VoxelConstants.getLogger().error(var11.getMessage(), (Throwable)var11);
        }
        return color;
    }

    private int getColorForTerrainSprite(class_2680 blockState, class_776 blockRendererDispatcher) {
        class_773 blockModelShapes = blockRendererDispatcher.method_3351();
        class_1058 icon = blockModelShapes.method_3339(blockState);
        if (icon == blockModelShapes.method_3333().method_4744().method_4711()) {
            class_2248 block = blockState.method_26204();
            class_3614 material = blockState.method_26207();
            if (block instanceof class_2404) {
                if (material == class_3614.field_15920) {
                    icon = (class_1058)VoxelConstants.getMinecraft().method_1549(class_1723.field_21668).apply(new class_2960("minecraft:blocks/water_flow"));
                } else if (material == class_3614.field_15922) {
                    icon = (class_1058)VoxelConstants.getMinecraft().method_1549(class_1723.field_21668).apply(new class_2960("minecraft:blocks/lava_flow"));
                }
            } else if (material == class_3614.field_15920) {
                icon = (class_1058)VoxelConstants.getMinecraft().method_1549(class_1723.field_21668).apply(new class_2960("minecraft:blocks/water_still"));
            } else if (material == class_3614.field_15922) {
                icon = (class_1058)VoxelConstants.getMinecraft().method_1549(class_1723.field_21668).apply(new class_2960("minecraft:blocks/lava_still"));
            }
        }
        return this.getColorForIcon(icon);
    }

    private int getColorForIcon(class_1058 icon) {
        int color = 0x1B000000;
        if (icon != null) {
            float left = icon.method_4594();
            float right = icon.method_4577();
            float top = icon.method_4593();
            float bottom = icon.method_4575();
            color = this.getColorForCoordinatesAndImage(new float[]{left, right, top, bottom}, this.terrainBuff);
        }
        return color;
    }

    private int getColorForCoordinatesAndImage(float[] uv, BufferedImage imageBuff) {
        int color = 0x1B000000;
        if (uv[0] != this.failedToLoadX || uv[2] != this.failedToLoadY) {
            int left = (int)(uv[0] * (float)imageBuff.getWidth());
            int right = (int)Math.ceil(uv[1] * (float)imageBuff.getWidth());
            int top = (int)(uv[2] * (float)imageBuff.getHeight());
            int bottom = (int)Math.ceil(uv[3] * (float)imageBuff.getHeight());
            try {
                BufferedImage blockTexture = imageBuff.getSubimage(left, top, right - left, bottom - top);
                Image singlePixel = blockTexture.getScaledInstance(1, 1, 4);
                BufferedImage singlePixelBuff = new BufferedImage(1, 1, imageBuff.getType());
                Graphics2D gfx = singlePixelBuff.createGraphics();
                gfx.drawImage(singlePixel, 0, 0, null);
                gfx.dispose();
                color = singlePixelBuff.getRGB(0, 0);
            }
            catch (RasterFormatException var12) {
                VoxelConstants.getLogger().warn("error getting color");
                VoxelConstants.getLogger().warn(IntStream.of(left, right, top, bottom).mapToObj(String::valueOf).collect(Collectors.joining(" ")));
            }
        }
        return color;
    }

    private void applyDefaultBuiltInShading(class_2680 blockState, int color) {
        class_2248 block = blockState.method_26204();
        int blockStateID = BlockRepository.getStateId(blockState);
        this.blockColorsWithDefaultTint[blockStateID] = block != BlockRepository.largeFern && block != BlockRepository.tallGrass && block != BlockRepository.reeds ? (block == BlockRepository.water ? ColorUtils.colorMultiplier(color, -16777216) : ColorUtils.colorMultiplier(color, VoxelConstants.getMinecraft().method_1505().method_1697(blockState, null, null, 0) | 0xFF000000)) : ColorUtils.colorMultiplier(color, class_1933.method_8377((double)0.7, (double)0.8) | 0xFF000000);
    }

    private void checkForBiomeTinting(MutableBlockPos blockPos, class_2680 blockState, int color) {
        try {
            class_2248 block = blockState.method_26204();
            String blockName = "" + class_7923.field_41175.method_10221((Object)block);
            if (BlockRepository.biomeBlocks.contains(block) || !blockName.startsWith("minecraft:")) {
                class_638 clientWorld;
                class_2791 chunk;
                MutableBlockPos tempBlockPos = new MutableBlockPos(0, 0, 0);
                int tint = blockPos == this.dummyBlockPos ? this.tintFromFakePlacedBlock(blockState, tempBlockPos, (byte)4) : ((chunk = (clientWorld = VoxelConstants.getClientWorld()).method_22350((class_2338)blockPos)) != null && !((class_2818)chunk).method_12223() && clientWorld.method_8393(blockPos.method_10263() >> 4, blockPos.method_10260() >> 4) ? VoxelConstants.getMinecraft().method_1505().method_1697(blockState, (class_1920)clientWorld, (class_2338)blockPos, 1) | 0xFF000000 : this.tintFromFakePlacedBlock(blockState, tempBlockPos, (byte)4));
                if (tint != 0xFFFFFF && tint != -1) {
                    int blockStateID = BlockRepository.getStateId(blockState);
                    this.biomeTintsAvailable.add(blockStateID);
                    this.blockColorsWithDefaultTint[blockStateID] = ColorUtils.colorMultiplier(color, tint);
                } else {
                    this.blockColorsWithDefaultTint[BlockRepository.getStateId((class_2680)blockState)] = 0x1B000000;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int tintFromFakePlacedBlock(class_2680 blockState, MutableBlockPos loopBlockPos, byte biomeID) {
        return -1;
    }

    public int getBiomeTint(AbstractMapData mapData, class_1937 world, class_2680 blockState, int blockStateID, MutableBlockPos blockPos, MutableBlockPos loopBlockPos, int startX, int startZ) {
        class_2791 chunk = world.method_22350((class_2338)blockPos);
        boolean live = chunk != null && !((class_2818)chunk).method_12223() && VoxelConstants.getPlayer().field_6002.method_8393(blockPos.method_10263() >> 4, blockPos.method_10260() >> 4);
        live = live && VoxelConstants.getPlayer().field_6002.method_22340((class_2338)blockPos);
        int tint = -2;
        if (this.optifineInstalled || !live && this.biomeTintsAvailable.contains(blockStateID)) {
            try {
                int[][] tints = this.blockTintTables.get(blockStateID);
                if (tints != null) {
                    int r = 0;
                    int g = 0;
                    int b = 0;
                    for (int t = blockPos.method_10263() - 1; t <= blockPos.method_10263() + 1; ++t) {
                        for (int s = blockPos.method_10260() - 1; s <= blockPos.method_10260() + 1; ++s) {
                            int biomeID;
                            if (live) {
                                biomeID = world.method_30349().method_30530(class_7924.field_41236).method_10206((Object)((class_1959)world.method_23753((class_2338)loopBlockPos.withXYZ(t, blockPos.method_10264(), s)).comp_349()));
                            } else {
                                int dataX = t - startX;
                                int dataZ = s - startZ;
                                dataX = Math.max(dataX, 0);
                                dataX = Math.min(dataX, mapData.getWidth() - 1);
                                dataZ = Math.max(dataZ, 0);
                                dataZ = Math.min(dataZ, mapData.getHeight() - 1);
                                biomeID = mapData.getBiomeID(dataX, dataZ);
                            }
                            if (biomeID < 0) {
                                biomeID = 1;
                            }
                            int biomeTint = tints[biomeID][loopBlockPos.y / 8];
                            r += (biomeTint & 0xFF0000) >> 16;
                            g += (biomeTint & 0xFF00) >> 8;
                            b += biomeTint & 0xFF;
                        }
                    }
                    tint = 0xFF000000 | (r / 9 & 0xFF) << 16 | (g / 9 & 0xFF) << 8 | b / 9 & 0xFF;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tint == -2) {
            tint = this.getBuiltInBiomeTint(mapData, world, blockState, blockStateID, blockPos, loopBlockPos, startX, startZ, live);
        }
        return tint;
    }

    private int getBuiltInBiomeTint(AbstractMapData mapData, class_1937 world, class_2680 blockState, int blockStateID, MutableBlockPos blockPos, MutableBlockPos loopBlockPos, int startX, int startZ, boolean live) {
        int tint = -1;
        class_2248 block = blockState.method_26204();
        if (BlockRepository.biomeBlocks.contains(block) || this.biomeTintsAvailable.contains(blockStateID)) {
            if (live) {
                try {
                    tint = VoxelConstants.getMinecraft().method_1505().method_1697(blockState, (class_1920)world, (class_2338)blockPos, 0) | 0xFF000000;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (tint == -1) {
                tint = this.getBuiltInBiomeTintFromUnloadedChunk(mapData, world, blockState, blockStateID, blockPos, loopBlockPos, startX, startZ) | 0xFF000000;
            }
        }
        return tint;
    }

    private int getBuiltInBiomeTintFromUnloadedChunk(AbstractMapData mapData, class_1937 world, class_2680 blockState, int blockStateID, MutableBlockPos blockPos, MutableBlockPos loopBlockPos, int startX, int startZ) {
        int tint = -1;
        class_2248 block = blockState.method_26204();
        ColorResolver colorResolver = null;
        if (block == BlockRepository.water) {
            colorResolver = this.waterColorResolver;
        } else if (block == BlockRepository.spruceLeaves) {
            colorResolver = this.spruceColorResolver;
        } else if (block == BlockRepository.birchLeaves) {
            colorResolver = this.birchColorResolver;
        } else if (block != BlockRepository.oakLeaves && block != BlockRepository.jungleLeaves && block != BlockRepository.acaciaLeaves && block != BlockRepository.darkOakLeaves && block != BlockRepository.mangroveLeaves && block != BlockRepository.vine) {
            if (block == BlockRepository.redstone) {
                colorResolver = this.redstoneColorResolver;
            } else if (BlockRepository.biomeBlocks.contains(block)) {
                colorResolver = this.grassColorResolver;
            }
        } else {
            colorResolver = this.foliageColorResolver;
        }
        if (colorResolver != null) {
            int r = 0;
            int g = 0;
            int b = 0;
            for (int t = blockPos.method_10263() - 1; t <= blockPos.method_10263() + 1; ++t) {
                for (int s = blockPos.method_10260() - 1; s <= blockPos.method_10260() + 1; ++s) {
                    int dataX = t - startX;
                    int dataZ = s - startZ;
                    dataX = Math.max(dataX, 0);
                    dataX = Math.min(dataX, 255);
                    dataZ = Math.max(dataZ, 0);
                    dataZ = Math.min(dataZ, 255);
                    int biomeID = mapData.getBiomeID(dataX, dataZ);
                    class_1959 biome = (class_1959)world.method_30349().method_30530(class_7924.field_41236).method_10200(biomeID);
                    if (biome == null) {
                        MessageUtils.printDebug("Null biome ID! " + biomeID + " at " + t + "," + s);
                        MessageUtils.printDebug("block: " + mapData.getBlockstate(dataX, dataZ) + ", height: " + mapData.getHeight(dataX, dataZ));
                        MessageUtils.printDebug("Mapdata: " + mapData);
                    }
                    int biomeTint = colorResolver.getColorAtPos(blockState, biome, loopBlockPos.withXYZ(t, blockPos.method_10264(), s));
                    r += (biomeTint & 0xFF0000) >> 16;
                    g += (biomeTint & 0xFF00) >> 8;
                    b += biomeTint & 0xFF;
                }
            }
            tint = (r / 9 & 0xFF) << 16 | (g / 9 & 0xFF) << 8 | b / 9 & 0xFF;
        } else if (this.biomeTintsAvailable.contains(blockStateID)) {
            tint = this.getCustomBlockBiomeTintFromUnloadedChunk(mapData, world, blockState, blockPos, loopBlockPos, startX, startZ);
        }
        return tint;
    }

    private int getCustomBlockBiomeTintFromUnloadedChunk(AbstractMapData mapData, class_1937 world, class_2680 blockState, MutableBlockPos blockPos, MutableBlockPos loopBlockPos, int startX, int startZ) {
        int tint;
        try {
            int dataX = blockPos.method_10263() - startX;
            int dataZ = blockPos.method_10260() - startZ;
            dataX = Math.max(dataX, 0);
            dataX = Math.min(dataX, mapData.getWidth() - 1);
            dataZ = Math.max(dataZ, 0);
            dataZ = Math.min(dataZ, mapData.getHeight() - 1);
            byte biomeID = (byte)mapData.getBiomeID(dataX, dataZ);
            tint = this.tintFromFakePlacedBlock(blockState, loopBlockPos, biomeID);
        }
        catch (Exception var12) {
            tint = -1;
        }
        return tint;
    }

    private int applyShape(class_2248 block, int color) {
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        if (block instanceof class_2478) {
            alpha = 31;
        } else if (block instanceof class_2323) {
            alpha = 47;
        } else if (block == BlockRepository.ladder || block == BlockRepository.vine) {
            alpha = 15;
        }
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    private void processCTM() {
        this.renderPassThreeBlendMode = "alpha";
        Properties properties = new Properties();
        class_2960 propertiesFile = new class_2960("minecraft", "optifine/renderpass.properties");
        try {
            InputStream input = ((class_3298)VoxelConstants.getMinecraft().method_1478().method_14486(propertiesFile).get()).method_14482();
            if (input != null) {
                properties.load(input);
                input.close();
                this.renderPassThreeBlendMode = properties.getProperty("blend.3", "alpha");
            }
        }
        catch (IOException var9) {
            this.renderPassThreeBlendMode = "alpha";
        }
        String namespace = "minecraft";
        for (class_2960 s : this.findResources(namespace, "/optifine/ctm", ".properties", true, false, true)) {
            try {
                this.loadCTM(s);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        for (int t = 0; t < this.blockColors.length; ++t) {
            if (this.blockColors[t] == 0x1B000000 || this.blockColors[t] == -16842497) continue;
            if ((this.blockColors[t] >> 24 & 0xFF) < 27) {
                int n = t;
                this.blockColors[n] = this.blockColors[n] | 0x1B000000;
            }
            this.checkForBiomeTinting(this.dummyBlockPos, BlockRepository.getStateById(t), this.blockColors[t]);
        }
    }

    private void loadCTM(class_2960 propertiesFile) {
        if (propertiesFile != null) {
            class_776 blockRendererDispatcher = VoxelConstants.getMinecraft().method_1541();
            class_773 blockModelShapes = blockRendererDispatcher.method_3351();
            Properties properties = new Properties();
            try {
                InputStream input = ((class_3298)VoxelConstants.getMinecraft().method_1478().method_14486(propertiesFile).get()).method_14482();
                if (input != null) {
                    properties.load(input);
                    input.close();
                }
            }
            catch (IOException var39) {
                return;
            }
            String filePath = propertiesFile.method_12832();
            String method = properties.getProperty("method", "").trim().toLowerCase();
            String faces = properties.getProperty("faces", "").trim().toLowerCase();
            String matchBlocks = properties.getProperty("matchBlocks", "").trim().toLowerCase();
            Object matchTiles = properties.getProperty("matchTiles", "").trim().toLowerCase();
            String metadata = properties.getProperty("metadata", "").trim().toLowerCase();
            String tiles = properties.getProperty("tiles", "").trim();
            String biomes = properties.getProperty("biomes", "").trim().toLowerCase();
            String renderPass = properties.getProperty("renderPass", "").trim().toLowerCase();
            metadata = metadata.replaceAll("\\s+", ",");
            HashSet<class_2680> blockStates = new HashSet<class_2680>(this.parseBlocksList(matchBlocks, metadata));
            String directory = filePath.substring(0, filePath.lastIndexOf("/") + 1);
            String[] tilesParsed = this.parseStringList(tiles);
            Object tilePath = directory + "0";
            if (tilesParsed.length > 0) {
                tilePath = tilesParsed[0].trim();
            }
            if (((String)tilePath).startsWith("~")) {
                tilePath = ((String)tilePath).replace("~", "optifine");
            } else if (!((String)tilePath).contains("/")) {
                tilePath = directory + (String)tilePath;
            }
            if (!((String)tilePath).toLowerCase().endsWith(".png")) {
                tilePath = (String)tilePath + ".png";
            }
            String[] biomesArray = biomes.split(" ");
            if (blockStates.isEmpty()) {
                Pattern pattern = Pattern.compile(".*/block_(.+).properties");
                Matcher matcher = pattern.matcher(filePath);
                if (matcher.find()) {
                    class_2248 block = this.getBlockFromName(matcher.group(1));
                    if (block != null) {
                        Set<class_2680> matching = this.parseBlockMetadata(block, metadata);
                        if (matching.isEmpty()) {
                            matching.addAll((Collection<class_2680>)block.method_9595().method_11662());
                        }
                        blockStates.addAll(matching);
                    }
                } else {
                    if (((String)matchTiles).isEmpty()) {
                        matchTiles = filePath.substring(filePath.lastIndexOf(47) + 1, filePath.lastIndexOf(".properties"));
                    }
                    if (!((String)matchTiles).contains(":")) {
                        matchTiles = "minecraft:blocks/" + (String)matchTiles;
                    }
                    class_2960 matchID = new class_2960((String)matchTiles);
                    class_1058 compareIcon = (class_1058)VoxelConstants.getMinecraft().method_1549(class_1723.field_21668).apply(matchID);
                    if (compareIcon.method_45852() != class_1047.method_4539()) {
                        ArrayList<class_2680> tmpList = new ArrayList<class_2680>();
                        for (class_2248 testBlock : class_7923.field_41175) {
                            for (class_2680 blockState : testBlock.method_9595().method_11662()) {
                                try {
                                    class_1087 bakedModel = blockModelShapes.method_3335(blockState);
                                    ArrayList<class_777> quads = new ArrayList<class_777>();
                                    quads.addAll(bakedModel.method_4707(blockState, class_2350.field_11036, this.random));
                                    quads.addAll(bakedModel.method_4707(blockState, null, this.random));
                                    BlockModel model = new BlockModel(quads, this.failedToLoadX, this.failedToLoadY);
                                    if (model.numberOfFaces() <= 0) continue;
                                    ArrayList<BlockModel.BlockFace> blockFaces = model.getFaces();
                                    for (int i = 0; i < blockFaces.size(); ++i) {
                                        float maxV;
                                        float minV;
                                        float maxU;
                                        BlockModel.BlockFace face = model.getFaces().get(i);
                                        float minU = face.getMinU();
                                        if (!this.similarEnough(minU, maxU = face.getMaxU(), minV = face.getMinV(), maxV = face.getMaxV(), compareIcon.method_4594(), compareIcon.method_4577(), compareIcon.method_4593(), compareIcon.method_4575())) continue;
                                        tmpList.add(blockState);
                                    }
                                }
                                catch (Exception exception) {
                                }
                            }
                        }
                        blockStates.addAll(tmpList);
                    }
                }
            }
            if (!blockStates.isEmpty() && !method.equals("horizontal") && !method.startsWith("overlay") && (method.equals("sandstone") || method.equals("top") || faces.contains("top") || faces.contains("all") || faces.isEmpty())) {
                try {
                    class_2960 pngResource = new class_2960(propertiesFile.method_12836(), (String)tilePath);
                    InputStream is = ((class_3298)VoxelConstants.getMinecraft().method_1478().method_14486(pngResource).get()).method_14482();
                    Image top = ImageIO.read(is);
                    is.close();
                    top = top.getScaledInstance(1, 1, 4);
                    BufferedImage topBuff = new BufferedImage(top.getWidth(null), top.getHeight(null), 6);
                    Graphics2D gfx = topBuff.createGraphics();
                    gfx.drawImage(top, 0, 0, null);
                    gfx.dispose();
                    int topRGB = topBuff.getRGB(0, 0);
                    if ((topRGB >> 24 & 0xFF) == 0) {
                        return;
                    }
                    for (class_2680 blockState : blockStates) {
                        int blockStateID;
                        topRGB = topBuff.getRGB(0, 0);
                        if (blockState.method_26204() == BlockRepository.cobweb) {
                            topRGB |= 0xFF000000;
                        }
                        if (renderPass.equals("3")) {
                            topRGB = this.processRenderPassThree(topRGB);
                            blockStateID = BlockRepository.getStateId(blockState);
                            int baseRGB = this.blockColors[blockStateID];
                            if (baseRGB != 0x1B000000 && baseRGB != -16842497) {
                                topRGB = ColorUtils.colorMultiplier(baseRGB, topRGB);
                            }
                        }
                        if (BlockRepository.shapedBlocks.contains(blockState.method_26204())) {
                            topRGB = this.applyShape(blockState.method_26204(), topRGB);
                        }
                        blockStateID = BlockRepository.getStateId(blockState);
                        if (!biomes.isEmpty()) {
                            this.biomeTextureAvailable.add(blockStateID);
                            for (String s : biomesArray) {
                                int biomeInt = this.parseBiomeName(s);
                                if (biomeInt == -1) continue;
                                this.blockBiomeSpecificColors.put(blockStateID + " " + biomeInt, topRGB);
                            }
                            continue;
                        }
                        this.blockColors[blockStateID] = topRGB;
                    }
                }
                catch (IOException var40) {
                    VoxelConstants.getLogger().error("error getting CTM block from " + propertiesFile.method_12832() + ": " + filePath + " " + class_7923.field_41175.method_10221((Object)((class_2680)blockStates.iterator().next()).method_26204()) + " " + (String)tilePath, (Throwable)var40);
                }
            }
        }
    }

    private boolean similarEnough(float a, float b, float c, float d, float one, float two, float three, float four) {
        boolean similar = (double)Math.abs(a - one) < 1.0E-4;
        similar = similar && (double)Math.abs(b - two) < 1.0E-4;
        similar = similar && (double)Math.abs(c - three) < 1.0E-4;
        return similar && (double)Math.abs(d - four) < 1.0E-4;
    }

    private int processRenderPassThree(int rgb) {
        if (this.renderPassThreeBlendMode.equals("color") || this.renderPassThreeBlendMode.equals("overlay")) {
            int red = rgb >> 16 & 0xFF;
            int green = rgb >> 8 & 0xFF;
            int blue = rgb & 0xFF;
            float colorAverage = (float)(red + blue + green) / 3.0f;
            float lighteningFactor = (colorAverage - 127.5f) * 2.0f;
            red += (int)((float)red * (lighteningFactor / 255.0f));
            int newAlpha = (int)Math.abs(lighteningFactor);
            rgb = newAlpha << 24 | (red & 0xFF) << 16 | ((green += (int)((float)red * (lighteningFactor / 255.0f))) & 0xFF) << 8 | (blue += (int)((float)red * (lighteningFactor / 255.0f))) & 0xFF;
        }
        return rgb;
    }

    private String[] parseStringList(String list) {
        ArrayList<Object> tmpList = new ArrayList<Object>();
        for (String token : list.split("\\s+")) {
            token = token.trim();
            try {
                if (token.matches("^\\d+$")) {
                    tmpList.add("" + Integer.parseInt(token));
                    continue;
                }
                if (token.matches("^\\d+-\\d+$")) {
                    String[] t = token.split("-");
                    int min = Integer.parseInt(t[0]);
                    int max = Integer.parseInt(t[1]);
                    for (int i = min; i <= max; ++i) {
                        tmpList.add("" + i);
                    }
                    continue;
                }
                if (token.isEmpty()) continue;
                tmpList.add(token);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return (String[])tmpList.toArray(String[]::new);
    }

    private Set<class_2680> parseBlocksList(String blocks, String metadataLine) {
        HashSet<class_2680> blockStates = new HashSet<class_2680>();
        for (String blockString : blocks.split("\\s+")) {
            StringBuilder metadata = new StringBuilder(metadataLine);
            blockString = blockString.trim();
            String[] blockComponents = blockString.split(":");
            int tokensUsed = 0;
            class_2248 block = this.getBlockFromName(blockComponents[0]);
            if (block != null) {
                tokensUsed = 1;
            } else if (blockComponents.length > 1 && (block = this.getBlockFromName(blockComponents[0] + ":" + blockComponents[1])) != null) {
                tokensUsed = 2;
            }
            if (block == null) continue;
            if (blockComponents.length > tokensUsed) {
                metadata = new StringBuilder(blockComponents[tokensUsed]);
                for (int t = tokensUsed + 1; t < blockComponents.length; ++t) {
                    metadata.append(":").append(blockComponents[t]);
                }
            }
            blockStates.addAll(this.parseBlockMetadata(block, metadata.toString()));
        }
        return blockStates;
    }

    private Set<class_2680> parseBlockMetadata(class_2248 block, String metadataList) {
        HashSet<class_2680> blockStates = new HashSet<class_2680>();
        if (metadataList.isEmpty()) {
            blockStates.addAll((Collection<class_2680>)block.method_9595().method_11662());
        } else {
            Set valuePairs = Arrays.stream(metadataList.split(":")).map(String::trim).filter(metadata -> metadata.contains("=")).collect(Collectors.toSet());
            if (!valuePairs.isEmpty()) {
                for (class_2680 blockState : block.method_9595().method_11662()) {
                    boolean matches = true;
                    for (String pair : valuePairs) {
                        String[] values;
                        class_2769 property;
                        String[] propertyAndValues = pair.split("\\s*=\\s*", 5);
                        if (propertyAndValues.length != 2 || (property = block.method_9595().method_11663(propertyAndValues[0])) == null) continue;
                        boolean valueIncluded = false;
                        for (String value : values = propertyAndValues[1].split(",")) {
                            if (property.method_11902() == Integer.class && value.matches("^\\d+-\\d+$")) {
                                String[] range = value.split("-");
                                int min = Integer.parseInt(range[0]);
                                int max = Integer.parseInt(range[1]);
                                int intValue = (Integer)blockState.method_11654(property);
                                if (intValue < min || intValue > max) continue;
                                valueIncluded = true;
                                continue;
                            }
                            if (blockState.method_11654(property).equals(property.method_11900(value))) continue;
                            valueIncluded = true;
                        }
                        matches = matches && valueIncluded;
                    }
                    if (!matches) continue;
                    blockStates.add(blockState);
                }
            }
        }
        return blockStates;
    }

    private int parseBiomeName(String name) {
        class_1959 biome = (class_1959)this.world.method_30349().method_30530(class_7924.field_41236).method_10223(new class_2960(name));
        return biome != null ? this.world.method_30349().method_30530(class_7924.field_41236).method_10206((Object)biome) : -1;
    }

    private List<class_2960> findResources(String namespace, String startingPath, String suffixMaybeNull, boolean recursive, boolean directories, boolean sortByFilename) {
        if (startingPath == null) {
            startingPath = "";
        }
        if (!startingPath.isEmpty() && startingPath.charAt(0) == '/') {
            startingPath = startingPath.substring(1);
        }
        String suffix = suffixMaybeNull == null ? "" : suffixMaybeNull;
        Map resourceMap = VoxelConstants.getMinecraft().method_1478().method_14488(startingPath, asset -> asset.method_12832().endsWith(suffix));
        ArrayList resources = resourceMap.keySet().stream().filter(candidate -> candidate.method_12836().equals(namespace)).collect(Collectors.toCollection(ArrayList::new));
        if (sortByFilename) {
            resources.sort((o1, o2) -> {
                String f2;
                String f1 = o1.method_12832().replaceAll(".*/", "").replaceFirst("\\.properties", "");
                int result = f1.compareTo(f2 = o2.method_12832().replaceAll(".*/", "").replaceFirst("\\.properties", ""));
                return result != 0 ? result : o1.method_12832().compareTo(o2.method_12832());
            });
        } else {
            resources.sort(Comparator.comparing(class_2960::method_12832));
        }
        return resources;
    }

    private void processColorProperties() {
        Properties properties = new Properties();
        try {
            InputStream input = ((class_3298)VoxelConstants.getMinecraft().method_1478().method_14486(new class_2960("optifine/color.properties")).get()).method_14482();
            if (input != null) {
                properties.load(input);
                input.close();
            }
        }
        catch (IOException exception) {
            VoxelConstants.getLogger().error((Object)exception);
        }
        class_2680 blockState = BlockRepository.lilypad.method_9564();
        int blockStateID = BlockRepository.getStateId(blockState);
        int lilyRGB = this.getBlockColor(blockStateID);
        int lilypadMultiplier = 2129968;
        String lilypadMultiplierString = properties.getProperty("lilypad");
        if (lilypadMultiplierString != null) {
            lilypadMultiplier = Integer.parseInt(lilypadMultiplierString, 16);
        }
        for (class_2680 padBlockState : BlockRepository.lilypad.method_9595().method_11662()) {
            blockStateID = BlockRepository.getStateId(padBlockState);
            this.blockColors[blockStateID] = ColorUtils.colorMultiplier(lilyRGB, lilypadMultiplier | 0xFF000000);
            this.blockColorsWithDefaultTint[blockStateID] = this.blockColors[blockStateID];
        }
        String defaultFormat = properties.getProperty("palette.format");
        boolean globalGrid = defaultFormat != null && defaultFormat.equalsIgnoreCase("grid");
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("palette.block")) continue;
            String filename = key.substring("palette.block.".length());
            filename = filename.replace("~", "optifine");
            this.processColorPropertyHelper(new class_2960(filename), properties.getProperty(key), globalGrid);
        }
        for (class_2960 resource : this.findResources("minecraft", "/optifine/colormap/blocks", ".properties", true, false, true)) {
            class_2960 resourcePNG;
            String source;
            Properties colorProperties;
            block13: {
                colorProperties = new Properties();
                try {
                    InputStream input = ((class_3298)VoxelConstants.getMinecraft().method_1478().method_14486(resource).get()).method_14482();
                    if (input == null) break block13;
                    colorProperties.load(input);
                    input.close();
                }
                catch (IOException var21) {
                    break;
                }
            }
            String names = colorProperties.getProperty("blocks");
            if (names == null) {
                String name = resource.method_12832();
                names = name = name.substring(name.lastIndexOf(47) + 1, name.lastIndexOf(".properties"));
            }
            if ((source = colorProperties.getProperty("source")) != null) {
                resourcePNG = new class_2960(resource.method_12836(), source);
                VoxelConstants.getMinecraft().method_1478().method_14486(resourcePNG);
            } else {
                resourcePNG = new class_2960(resource.method_12836(), resource.method_12832().replace(".properties", ".png"));
            }
            String format = colorProperties.getProperty("format");
            boolean grid = format != null ? format.equalsIgnoreCase("grid") : globalGrid;
            String yOffsetString = colorProperties.getProperty("yOffset");
            int yOffset = 0;
            if (yOffsetString != null) {
                yOffset = Integer.parseInt(yOffsetString);
            }
            this.processColorProperty(resourcePNG, names, grid, yOffset);
        }
        this.processColorPropertyHelper(new class_2960("optifine/colormap/water.png"), "water", globalGrid);
        this.processColorPropertyHelper(new class_2960("optifine/colormap/watercolorx.png"), "water", globalGrid);
        this.processColorPropertyHelper(new class_2960("optifine/colormap/swampgrass.png"), "grass_block grass fern tall_grass large_fern", globalGrid);
        this.processColorPropertyHelper(new class_2960("optifine/colormap/swampgrasscolor.png"), "grass_block grass fern tall_grass large_fern", globalGrid);
        this.processColorPropertyHelper(new class_2960("optifine/colormap/swampfoliage.png"), "oak_leaves vine", globalGrid);
        this.processColorPropertyHelper(new class_2960("optifine/colormap/swampfoliagecolor.png"), "oak_leaves vine", globalGrid);
        this.processColorPropertyHelper(new class_2960("optifine/colormap/pine.png"), "spruce_leaves", globalGrid);
        this.processColorPropertyHelper(new class_2960("optifine/colormap/pinecolor.png"), "spruce_leaves", globalGrid);
        this.processColorPropertyHelper(new class_2960("optifine/colormap/birch.png"), "birch_leaves", globalGrid);
        this.processColorPropertyHelper(new class_2960("optifine/colormap/birchcolor.png"), "birch_leaves", globalGrid);
    }

    private void processColorPropertyHelper(class_2960 resource, String list, boolean grid) {
        class_2960 resourceProperties = new class_2960(resource.method_12836(), resource.method_12832().replace(".png", ".properties"));
        Properties colorProperties = new Properties();
        int yOffset = 0;
        try {
            String yOffsetString;
            String format;
            InputStream input = ((class_3298)VoxelConstants.getMinecraft().method_1478().method_14486(resourceProperties).get()).method_14482();
            if (input != null) {
                colorProperties.load(input);
                input.close();
            }
            if ((format = colorProperties.getProperty("format")) != null) {
                grid = format.equalsIgnoreCase("grid");
            }
            if ((yOffsetString = colorProperties.getProperty("yOffset")) != null) {
                yOffset = Integer.parseInt(yOffsetString);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.processColorProperty(resource, list, grid, yOffset);
    }

    private void processColorProperty(class_2960 resource, String list, boolean grid, int yOffset) {
        BufferedImage tintColors;
        int[][] tints;
        for (int[] row : tints = new int[this.sizeOfBiomeArray][32]) {
            Arrays.fill(row, -1);
        }
        boolean swamp = resource.method_12832().contains("/swamp");
        try {
            InputStream is = ((class_3298)VoxelConstants.getMinecraft().method_1478().method_14486(resource).get()).method_14482();
            tintColors = ImageIO.read(is);
            is.close();
        }
        catch (IOException var21) {
            return;
        }
        BufferedImage tintColorsBuff = new BufferedImage(((Image)tintColors).getWidth(null), ((Image)tintColors).getHeight(null), 1);
        Graphics2D gfx = tintColorsBuff.createGraphics();
        gfx.drawImage((Image)tintColors, 0, 0, null);
        gfx.dispose();
        int numBiomesToCheck = grid ? Math.min(tintColorsBuff.getWidth(), this.sizeOfBiomeArray) : this.sizeOfBiomeArray;
        for (int t = 0; t < numBiomesToCheck; ++t) {
            class_1959 biome = (class_1959)this.world.method_30349().method_30530(class_7924.field_41236).method_10200(t);
            if (biome == null) continue;
            int heightMultiplier = tintColorsBuff.getHeight() / 32;
            for (int s = 0; s < 32; ++s) {
                int tintMult;
                if (grid) {
                    tintMult = tintColorsBuff.getRGB(t, Math.max(0, s * heightMultiplier - yOffset)) & 0xFFFFFF;
                } else {
                    double var1 = class_3532.method_15363((float)biome.method_8712(), (float)0.0f, (float)1.0f);
                    double var2 = class_3532.method_15363((float)((BiomeAccessor)biome).getWeather().comp_846(), (float)0.0f, (float)1.0f);
                    var2 *= var1;
                    var1 = 1.0 - var1;
                    var2 = 1.0 - var2;
                    tintMult = tintColorsBuff.getRGB((int)((double)(tintColorsBuff.getWidth() - 1) * var1), (int)((double)(tintColorsBuff.getHeight() - 1) * var2)) & 0xFFFFFF;
                }
                if (tintMult == 0 || swamp) continue;
                tints[t][s] = tintMult;
            }
        }
        HashSet<class_2680> blockStates = new HashSet<class_2680>(this.parseBlocksList(list, ""));
        for (class_2680 blockState : blockStates) {
            int blockStateID = BlockRepository.getStateId(blockState);
            int[][] previousTints = this.blockTintTables.get(blockStateID);
            if (swamp && previousTints == null) {
                class_2960 defaultResource = resource.method_12832().contains("grass") ? new class_2960("textures/colormap/grass.png") : new class_2960("textures/colormap/foliage.png");
                String stateString = blockState.toString().toLowerCase();
                stateString = stateString.replaceAll("^block", "");
                stateString = stateString.replace("{", "");
                stateString = stateString.replace("}", "");
                stateString = stateString.replace("[", ":");
                stateString = stateString.replace("]", "");
                stateString = stateString.replace(",", ":");
                this.processColorProperty(defaultResource, stateString, false, 0);
                previousTints = this.blockTintTables.get(blockStateID);
            }
            if (previousTints != null) {
                for (int t = 0; t < this.sizeOfBiomeArray; ++t) {
                    for (int s = 0; s < 32; ++s) {
                        if (tints[t][s] != -1) continue;
                        tints[t][s] = previousTints[t][s];
                    }
                }
            }
            this.blockColorsWithDefaultTint[blockStateID] = ColorUtils.colorMultiplier(this.getBlockColor(blockStateID), tints[4][8] | 0xFF000000);
            this.blockTintTables.put(blockStateID, tints);
            this.biomeTintsAvailable.add(blockStateID);
        }
    }

    private class_2248 getBlockFromName(String name) {
        try {
            class_2960 resourceLocation = new class_2960(name);
            return class_7923.field_41175.method_10250(resourceLocation) ? (class_2248)class_7923.field_41175.method_10223(resourceLocation) : null;
        }
        catch (NumberFormatException | class_151 var3) {
            return null;
        }
    }

    @FunctionalInterface
    private static interface ColorResolver {
        public int getColorAtPos(class_2680 var1, class_1959 var2, class_2338 var3);
    }
}

