/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.gui.overridden.EnumOptionsMinimap;
import com.mamiyaotaru.voxelmap.interfaces.ISettingsManager;
import com.mamiyaotaru.voxelmap.interfaces.ISubSettingsManager;
import com.mamiyaotaru.voxelmap.util.MessageUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_3675;

public class MapSettingsManager
implements ISettingsManager {
    private File settingsFile;
    public boolean showUnderMenus;
    private final int availableProcessors = Runtime.getRuntime().availableProcessors();
    public final boolean multicore = this.availableProcessors > 1;
    public boolean hide;
    public boolean coords = true;
    protected boolean showCaves = true;
    public boolean lightmap = true;
    public boolean heightmap = this.multicore;
    public boolean slopemap = true;
    public boolean filtering;
    public boolean waterTransparency = this.multicore;
    public boolean blockTransparency = this.multicore;
    public boolean biomes = this.multicore;
    public int biomeOverlay;
    public boolean chunkGrid;
    public boolean slimeChunks;
    public boolean squareMap = true;
    public boolean rotates = true;
    public boolean oldNorth;
    public boolean showBeacons;
    public boolean showWaypoints = true;
    private boolean preToggleBeacons;
    private boolean preToggleSigns = true;
    public int deathpoints = 1;
    public int maxWaypointDisplayDistance = 1000;
    protected boolean welcome = true;
    public int zoom = 2;
    public int sizeModifier = 1;
    public int mapCorner = 1;
    public Boolean cavesAllowed = true;
    public int sort = 1;
    protected boolean realTimeTorches;
    public final class_304 keyBindZoom = new class_304("key.minimap.zoom", class_3675.method_15981((String)"key.keyboard.z").method_1444(), "controls.minimap.title");
    public final class_304 keyBindFullscreen = new class_304("key.minimap.togglefullscreen", class_3675.method_15981((String)"key.keyboard.x").method_1444(), "controls.minimap.title");
    public final class_304 keyBindMenu = new class_304("key.minimap.voxelmapmenu", class_3675.method_15981((String)"key.keyboard.m").method_1444(), "controls.minimap.title");
    public final class_304 keyBindWaypointMenu = new class_304("key.minimap.waypointmenu", -1, "controls.minimap.title");
    public final class_304 keyBindWaypoint = new class_304("key.minimap.waypointhotkey", class_3675.method_15981((String)"key.keyboard.n").method_1444(), "controls.minimap.title");
    public final class_304 keyBindMobToggle = new class_304("key.minimap.togglemobs", -1, "controls.minimap.title");
    public final class_304 keyBindWaypointToggle = new class_304("key.minimap.toggleingamewaypoints", -1, "controls.minimap.title");
    public final class_304[] keyBindings;
    private boolean somethingChanged;
    public static MapSettingsManager instance;
    private final List<ISubSettingsManager> subSettingsManagers = new ArrayList<ISubSettingsManager>();

    public MapSettingsManager() {
        instance = this;
        this.keyBindings = new class_304[]{this.keyBindMenu, this.keyBindWaypointMenu, this.keyBindZoom, this.keyBindFullscreen, this.keyBindWaypoint, this.keyBindMobToggle, this.keyBindWaypointToggle};
    }

    public void addSecondaryOptionsManager(ISubSettingsManager secondarySettingsManager) {
        this.subSettingsManagers.add(secondarySettingsManager);
    }

    public void loadAll() {
        this.settingsFile = new File(VoxelConstants.getMinecraft().field_1697, "config/voxelmap.properties");
        try {
            if (this.settingsFile.exists()) {
                String sCurrentLine;
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.settingsFile), StandardCharsets.UTF_8.newDecoder()));
                while ((sCurrentLine = in.readLine()) != null) {
                    String[] curLine = sCurrentLine.split(":");
                    switch (curLine[0]) {
                        case "Zoom Level": {
                            this.zoom = Math.max(0, Math.min(4, Integer.parseInt(curLine[1])));
                            break;
                        }
                        case "Hide Minimap": {
                            this.hide = Boolean.parseBoolean(curLine[1]);
                            break;
                        }
                        case "Show Coordinates": {
                            this.coords = Boolean.parseBoolean(curLine[1]);
                            break;
                        }
                        case "Enable Cave Mode": {
                            this.showCaves = Boolean.parseBoolean(curLine[1]);
                            break;
                        }
                        case "Dynamic Lighting": {
                            this.lightmap = Boolean.parseBoolean(curLine[1]);
                            break;
                        }
                        case "Height Map": {
                            this.heightmap = Boolean.parseBoolean(curLine[1]);
                            break;
                        }
                        case "Slope Map": {
                            this.slopemap = Boolean.parseBoolean(curLine[1]);
                            break;
                        }
                        case "Blur": {
                            this.filtering = Boolean.parseBoolean(curLine[1]);
                            break;
                        }
                        case "Water Transparency": {
                            this.waterTransparency = Boolean.parseBoolean(curLine[1]);
                            break;
                        }
                        case "Block Transparency": {
                            this.blockTransparency = Boolean.parseBoolean(curLine[1]);
                            break;
                        }
                        case "Biomes": {
                            this.biomes = Boolean.parseBoolean(curLine[1]);
                            break;
                        }
                        case "Biome Overlay": {
                            this.biomeOverlay = Math.max(0, Math.min(2, Integer.parseInt(curLine[1])));
                            break;
                        }
                        case "Chunk Grid": {
                            this.chunkGrid = Boolean.parseBoolean(curLine[1]);
                            break;
                        }
                        case "Slime Chunks": {
                            this.slimeChunks = Boolean.parseBoolean(curLine[1]);
                            break;
                        }
                        case "Square Map": {
                            this.squareMap = Boolean.parseBoolean(curLine[1]);
                            break;
                        }
                        case "Rotation": {
                            this.rotates = Boolean.parseBoolean(curLine[1]);
                            break;
                        }
                        case "Old North": {
                            this.oldNorth = Boolean.parseBoolean(curLine[1]);
                            break;
                        }
                        case "Waypoint Beacons": {
                            this.showBeacons = Boolean.parseBoolean(curLine[1]);
                            break;
                        }
                        case "Waypoint Signs": {
                            this.showWaypoints = Boolean.parseBoolean(curLine[1]);
                            break;
                        }
                        case "Deathpoints": {
                            this.deathpoints = Math.max(0, Math.min(2, Integer.parseInt(curLine[1])));
                            break;
                        }
                        case "Waypoint Max Distance": {
                            this.maxWaypointDisplayDistance = Math.max(-1, Math.min(10000, Integer.parseInt(curLine[1])));
                            break;
                        }
                        case "Waypoint Sort By": {
                            this.sort = Math.max(1, Math.min(4, Integer.parseInt(curLine[1])));
                            break;
                        }
                        case "Welcome Message": {
                            this.welcome = Boolean.parseBoolean(curLine[1]);
                            break;
                        }
                        case "Real Time Torch Flicker": {
                            this.realTimeTorches = Boolean.parseBoolean(curLine[1]);
                            break;
                        }
                        case "Map Corner": {
                            this.mapCorner = Math.max(0, Math.min(3, Integer.parseInt(curLine[1])));
                            break;
                        }
                        case "Map Size": {
                            this.sizeModifier = Math.max(-1, Math.min(4, Integer.parseInt(curLine[1])));
                            break;
                        }
                        case "Zoom Key": {
                            this.bindKey(this.keyBindZoom, curLine[1]);
                            break;
                        }
                        case "Fullscreen Key": {
                            this.bindKey(this.keyBindFullscreen, curLine[1]);
                            break;
                        }
                        case "Menu Key": {
                            this.bindKey(this.keyBindMenu, curLine[1]);
                            break;
                        }
                        case "Waypoint Menu Key": {
                            this.bindKey(this.keyBindWaypointMenu, curLine[1]);
                            break;
                        }
                        case "Waypoint Key": {
                            this.bindKey(this.keyBindWaypoint, curLine[1]);
                            break;
                        }
                        case "Mob Key": {
                            this.bindKey(this.keyBindMobToggle, curLine[1]);
                            break;
                        }
                        case "In-game Waypoint Key": {
                            this.bindKey(this.keyBindWaypointToggle, curLine[1]);
                        }
                    }
                    class_304.method_1426();
                }
                for (ISubSettingsManager subSettingsManager : this.subSettingsManagers) {
                    subSettingsManager.loadSettings(this.settingsFile);
                }
                in.close();
            }
            this.saveAll();
        }
        catch (IOException exception) {
            VoxelConstants.getLogger().error((Object)exception);
        }
    }

    private void bindKey(class_304 keyBinding, String id) {
        try {
            keyBinding.method_1422(class_3675.method_15981((String)id));
        }
        catch (RuntimeException var4) {
            VoxelConstants.getLogger().warn(id + " is not a valid keybinding");
        }
    }

    public void saveAll() {
        File settingsFileDir = new File(VoxelConstants.getMinecraft().field_1697, "/config/");
        if (!settingsFileDir.exists()) {
            settingsFileDir.mkdirs();
        }
        this.settingsFile = new File(settingsFileDir, "voxelmap.properties");
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.settingsFile), StandardCharsets.UTF_8.newEncoder())));
            out.println("Zoom Level:" + this.zoom);
            out.println("Hide Minimap:" + this.hide);
            out.println("Show Coordinates:" + this.coords);
            out.println("Enable Cave Mode:" + this.showCaves);
            out.println("Dynamic Lighting:" + this.lightmap);
            out.println("Height Map:" + this.heightmap);
            out.println("Slope Map:" + this.slopemap);
            out.println("Blur:" + this.filtering);
            out.println("Water Transparency:" + this.waterTransparency);
            out.println("Block Transparency:" + this.blockTransparency);
            out.println("Biomes:" + this.biomes);
            out.println("Biome Overlay:" + this.biomeOverlay);
            out.println("Chunk Grid:" + this.chunkGrid);
            out.println("Slime Chunks:" + this.slimeChunks);
            out.println("Square Map:" + this.squareMap);
            out.println("Rotation:" + this.rotates);
            out.println("Old North:" + this.oldNorth);
            out.println("Waypoint Beacons:" + this.showBeacons);
            out.println("Waypoint Signs:" + this.showWaypoints);
            out.println("Deathpoints:" + this.deathpoints);
            out.println("Waypoint Max Distance:" + this.maxWaypointDisplayDistance);
            out.println("Waypoint Sort By:" + this.sort);
            out.println("Welcome Message:" + this.welcome);
            out.println("Map Corner:" + this.mapCorner);
            out.println("Map Size:" + this.sizeModifier);
            out.println("Zoom Key:" + this.keyBindZoom.method_1428());
            out.println("Fullscreen Key:" + this.keyBindFullscreen.method_1428());
            out.println("Menu Key:" + this.keyBindMenu.method_1428());
            out.println("Waypoint Menu Key:" + this.keyBindWaypointMenu.method_1428());
            out.println("Waypoint Key:" + this.keyBindWaypoint.method_1428());
            out.println("Mob Key:" + this.keyBindMobToggle.method_1428());
            out.println("In-game Waypoint Key:" + this.keyBindWaypointToggle.method_1428());
            for (ISubSettingsManager subSettingsManager : this.subSettingsManagers) {
                subSettingsManager.saveAll(out);
            }
            out.close();
        }
        catch (FileNotFoundException var5) {
            MessageUtils.chatInfo("\u00a7EError Saving Settings " + var5.getLocalizedMessage());
        }
    }

    @Override
    public String getKeyText(EnumOptionsMinimap options) {
        String s = class_1074.method_4662((String)options.getName(), (Object[])new Object[0]) + ": ";
        if (options.isFloat()) {
            float f = this.getOptionFloatValue(options);
            if (options == EnumOptionsMinimap.ZOOM) {
                return s + (int)f;
            }
            if (options == EnumOptionsMinimap.WAYPOINTDISTANCE) {
                return f < 0.0f ? s + class_1074.method_4662((String)"options.minimap.waypoints.infinite", (Object[])new Object[0]) : s + (int)f;
            }
            return f == 0.0f ? s + class_1074.method_4662((String)"options.off", (Object[])new Object[0]) : s + (int)f + "%";
        }
        if (options.isBoolean()) {
            boolean flag = this.getOptionBooleanValue(options);
            return flag ? s + class_1074.method_4662((String)"options.on", (Object[])new Object[0]) : s + class_1074.method_4662((String)"options.off", (Object[])new Object[0]);
        }
        if (options.isList()) {
            String state = this.getOptionListValue(options);
            return s + state;
        }
        return s;
    }

    @Override
    public float getOptionFloatValue(EnumOptionsMinimap options) {
        if (options == EnumOptionsMinimap.ZOOM) {
            return this.zoom;
        }
        return options == EnumOptionsMinimap.WAYPOINTDISTANCE ? (float)this.maxWaypointDisplayDistance : 0.0f;
    }

    public boolean getOptionBooleanValue(EnumOptionsMinimap par1EnumOptions) {
        return switch (par1EnumOptions) {
            case EnumOptionsMinimap.COORDS -> this.coords;
            case EnumOptionsMinimap.HIDE -> this.hide;
            case EnumOptionsMinimap.CAVEMODE -> {
                if (this.cavesAllowed.booleanValue() && this.showCaves) {
                    yield true;
                }
                yield false;
            }
            case EnumOptionsMinimap.LIGHTING -> this.lightmap;
            case EnumOptionsMinimap.SQUARE -> this.squareMap;
            case EnumOptionsMinimap.ROTATES -> this.rotates;
            case EnumOptionsMinimap.OLDNORTH -> this.oldNorth;
            case EnumOptionsMinimap.WELCOME -> this.welcome;
            case EnumOptionsMinimap.FILTERING -> this.filtering;
            case EnumOptionsMinimap.WATERTRANSPARENCY -> this.waterTransparency;
            case EnumOptionsMinimap.BLOCKTRANSPARENCY -> this.blockTransparency;
            case EnumOptionsMinimap.BIOMES -> this.biomes;
            case EnumOptionsMinimap.CHUNKGRID -> this.chunkGrid;
            case EnumOptionsMinimap.SLIMECHUNKS -> this.slimeChunks;
            default -> throw new IllegalArgumentException("Add code to handle EnumOptionMinimap: " + par1EnumOptions.getName() + ". (possibly not a boolean applicable to minimap)");
        };
    }

    public String getOptionListValue(EnumOptionsMinimap par1EnumOptions) {
        switch (par1EnumOptions) {
            case TERRAIN: {
                if (this.slopemap && this.heightmap) {
                    return class_1074.method_4662((String)"options.minimap.terrain.both", (Object[])new Object[0]);
                }
                if (this.heightmap) {
                    return class_1074.method_4662((String)"options.minimap.terrain.height", (Object[])new Object[0]);
                }
                if (this.slopemap) {
                    return class_1074.method_4662((String)"options.minimap.terrain.slope", (Object[])new Object[0]);
                }
                return class_1074.method_4662((String)"options.off", (Object[])new Object[0]);
            }
            case BEACONS: {
                if (this.showBeacons && this.showWaypoints) {
                    return class_1074.method_4662((String)"options.minimap.ingamewaypoints.both", (Object[])new Object[0]);
                }
                if (this.showBeacons) {
                    return class_1074.method_4662((String)"options.minimap.ingamewaypoints.beacons", (Object[])new Object[0]);
                }
                if (this.showWaypoints) {
                    return class_1074.method_4662((String)"options.minimap.ingamewaypoints.signs", (Object[])new Object[0]);
                }
                return class_1074.method_4662((String)"options.off", (Object[])new Object[0]);
            }
            case LOCATION: {
                if (this.mapCorner == 0) {
                    return class_1074.method_4662((String)"options.minimap.location.topleft", (Object[])new Object[0]);
                }
                if (this.mapCorner == 1) {
                    return class_1074.method_4662((String)"options.minimap.location.topright", (Object[])new Object[0]);
                }
                if (this.mapCorner == 2) {
                    return class_1074.method_4662((String)"options.minimap.location.bottomright", (Object[])new Object[0]);
                }
                if (this.mapCorner == 3) {
                    return class_1074.method_4662((String)"options.minimap.location.bottomleft", (Object[])new Object[0]);
                }
                return "Error";
            }
            case SIZE: {
                if (this.sizeModifier == -1) {
                    return class_1074.method_4662((String)"options.minimap.size.small", (Object[])new Object[0]);
                }
                if (this.sizeModifier == 0) {
                    return class_1074.method_4662((String)"options.minimap.size.medium", (Object[])new Object[0]);
                }
                if (this.sizeModifier == 1) {
                    return class_1074.method_4662((String)"options.minimap.size.large", (Object[])new Object[0]);
                }
                if (this.sizeModifier == 2) {
                    return class_1074.method_4662((String)"options.minimap.size.xl", (Object[])new Object[0]);
                }
                if (this.sizeModifier == 3) {
                    return class_1074.method_4662((String)"options.minimap.size.xxl", (Object[])new Object[0]);
                }
                if (this.sizeModifier == 4) {
                    return class_1074.method_4662((String)"options.minimap.size.xxxl", (Object[])new Object[0]);
                }
                return "error";
            }
            case BIOMEOVERLAY: {
                if (this.biomeOverlay == 0) {
                    return class_1074.method_4662((String)"options.off", (Object[])new Object[0]);
                }
                if (this.biomeOverlay == 1) {
                    return class_1074.method_4662((String)"options.minimap.biomeoverlay.solid", (Object[])new Object[0]);
                }
                if (this.biomeOverlay == 2) {
                    return class_1074.method_4662((String)"options.minimap.biomeoverlay.transparent", (Object[])new Object[0]);
                }
                return "error";
            }
            case DEATHPOINTS: {
                if (this.deathpoints == 0) {
                    return class_1074.method_4662((String)"options.off", (Object[])new Object[0]);
                }
                if (this.deathpoints == 1) {
                    return class_1074.method_4662((String)"options.minimap.waypoints.deathpoints.mostrecent", (Object[])new Object[0]);
                }
                if (this.deathpoints == 2) {
                    return class_1074.method_4662((String)"options.minimap.waypoints.deathpoints.all", (Object[])new Object[0]);
                }
                return "error";
            }
        }
        throw new IllegalArgumentException("Add code to handle EnumOptionMinimap: " + par1EnumOptions.getName() + ". (possibly not a list value applicable to minimap)");
    }

    @Override
    public void setOptionFloatValue(EnumOptionsMinimap options, float value) {
        if (options == EnumOptionsMinimap.WAYPOINTDISTANCE) {
            float distance = value * 9951.0f + 50.0f;
            if (distance > 10000.0f) {
                distance = -1.0f;
            }
            this.maxWaypointDisplayDistance = (int)distance;
        }
        this.somethingChanged = true;
    }

    public void setOptionValue(EnumOptionsMinimap par1EnumOptions) {
        switch (par1EnumOptions) {
            case COORDS: {
                this.coords = !this.coords;
                break;
            }
            case HIDE: {
                this.hide = !this.hide;
                break;
            }
            case CAVEMODE: {
                this.showCaves = !this.showCaves;
                break;
            }
            case LIGHTING: {
                this.lightmap = !this.lightmap;
                break;
            }
            case SQUARE: {
                this.squareMap = !this.squareMap;
                break;
            }
            case ROTATES: {
                this.rotates = !this.rotates;
                break;
            }
            case OLDNORTH: {
                this.oldNorth = !this.oldNorth;
                break;
            }
            case WELCOME: {
                this.welcome = !this.welcome;
                break;
            }
            case FILTERING: {
                this.filtering = !this.filtering;
                break;
            }
            case WATERTRANSPARENCY: {
                this.waterTransparency = !this.waterTransparency;
                break;
            }
            case BLOCKTRANSPARENCY: {
                this.blockTransparency = !this.blockTransparency;
                break;
            }
            case BIOMES: {
                this.biomes = !this.biomes;
                break;
            }
            case CHUNKGRID: {
                this.chunkGrid = !this.chunkGrid;
                break;
            }
            case SLIMECHUNKS: {
                this.slimeChunks = !this.slimeChunks;
                break;
            }
            case TERRAIN: {
                if (this.slopemap && this.heightmap) {
                    this.slopemap = false;
                    this.heightmap = false;
                    break;
                }
                if (this.slopemap) {
                    this.slopemap = false;
                    this.heightmap = true;
                    break;
                }
                if (this.heightmap) {
                    this.slopemap = true;
                    break;
                }
                this.slopemap = true;
                break;
            }
            case BEACONS: {
                if (this.showBeacons && this.showWaypoints) {
                    this.showBeacons = false;
                    this.showWaypoints = false;
                    break;
                }
                if (this.showBeacons) {
                    this.showBeacons = false;
                    this.showWaypoints = true;
                    break;
                }
                if (this.showWaypoints) {
                    this.showBeacons = true;
                    break;
                }
                this.showBeacons = true;
                break;
            }
            case LOCATION: {
                this.mapCorner = this.mapCorner >= 3 ? 0 : this.mapCorner + 1;
                break;
            }
            case SIZE: {
                this.sizeModifier = this.sizeModifier >= 4 ? -1 : this.sizeModifier + 1;
                break;
            }
            case BIOMEOVERLAY: {
                ++this.biomeOverlay;
                if (this.biomeOverlay <= 2) break;
                this.biomeOverlay = 0;
                break;
            }
            case DEATHPOINTS: {
                ++this.deathpoints;
                if (this.deathpoints <= 2) break;
                this.deathpoints = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Add code to handle EnumOptionMinimap: " + par1EnumOptions.getName());
            }
        }
        this.somethingChanged = true;
    }

    public void toggleIngameWaypoints() {
        if (!this.showBeacons && !this.showWaypoints) {
            this.showBeacons = this.preToggleBeacons;
            this.showWaypoints = this.preToggleSigns;
        } else {
            this.preToggleBeacons = this.showBeacons;
            this.preToggleSigns = this.showWaypoints;
            this.showBeacons = false;
            this.showWaypoints = false;
        }
    }

    public String getKeyBindingDescription(int keybindIndex) {
        return this.keyBindings[keybindIndex].method_1431().equals("key.minimap.voxelmapmenu") ? class_1074.method_4662((String)"key.minimap.menu", (Object[])new Object[0]) : class_1074.method_4662((String)this.keyBindings[keybindIndex].method_1431(), (Object[])new Object[0]);
    }

    public class_2561 getKeybindDisplayString(int keybindIndex) {
        class_304 keyBinding = this.keyBindings[keybindIndex];
        return this.getKeybindDisplayString(keyBinding);
    }

    public class_2561 getKeybindDisplayString(class_304 keyBinding) {
        return keyBinding.method_16007();
    }

    public void setKeyBinding(class_304 keyBinding, class_3675.class_306 input) {
        keyBinding.method_1422(input);
        this.saveAll();
    }

    public void setSort(int sort) {
        this.sort = sort != this.sort && sort != -this.sort ? sort : -this.sort;
    }

    public boolean isChanged() {
        if (this.somethingChanged) {
            this.somethingChanged = false;
            return true;
        }
        return false;
    }
}

