/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.RadarSettingsManager;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.gui.GuiMobs;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiSlotMinimap;
import com.mamiyaotaru.voxelmap.util.CustomMob;
import com.mamiyaotaru.voxelmap.util.CustomMobsManager;
import com.mamiyaotaru.voxelmap.util.EnumMobs;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.OpenGL;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_350;
import net.minecraft.class_4587;

class GuiSlotMobs
extends GuiSlotMinimap {
    private final ArrayList<MobItem> mobs;
    private ArrayList<class_350.class_351<?>> mobsFiltered;
    final GuiMobs parentGui;
    static final class_2561 ENABLE = class_2561.method_43471((String)"options.minimap.mobs.enable");
    static final class_2561 DISABLE = class_2561.method_43471((String)"options.minimap.mobs.disable");
    static final class_2561 ENABLED = class_2561.method_43471((String)"options.minimap.mobs.enabled");
    static final class_2561 DISABLED = class_2561.method_43471((String)"options.minimap.mobs.disabled");
    final class_2960 visibleIconIdentifier = new class_2960("textures/mob_effect/night_vision.png");
    final class_2960 invisibleIconIdentifier = new class_2960("textures/mob_effect/blindness.png");

    GuiSlotMobs(GuiMobs par1GuiMobs) {
        super(par1GuiMobs.getWidth(), par1GuiMobs.getHeight(), 32, par1GuiMobs.getHeight() - 65 + 4, 18);
        this.parentGui = par1GuiMobs;
        RadarSettingsManager options = this.parentGui.options;
        this.mobs = new ArrayList();
        for (EnumMobs mob : EnumMobs.values()) {
            if (!mob.isTopLevelUnit || (!mob.isHostile || !options.showHostiles) && (!mob.isNeutral || !options.showNeutrals)) continue;
            this.mobs.add(new MobItem(this.parentGui, mob.id));
        }
        for (CustomMob mob : CustomMobsManager.mobs) {
            if ((!mob.isHostile || !options.showHostiles) && (!mob.isNeutral || !options.showNeutrals)) continue;
            this.mobs.add(new MobItem(this.parentGui, mob.id));
        }
        this.mobs.sort((mob1, mob2) -> String.CASE_INSENSITIVE_ORDER.compare(mob1.name, mob2.name));
        this.mobsFiltered = new ArrayList<MobItem>(this.mobs);
        this.mobsFiltered.forEach((Consumer<class_350.class_351<?>>)((Consumer<class_350.class_351>)x$0 -> this.method_25321((class_350.class_351)x$0)));
    }

    private static String getTranslatedName(String name) {
        if (!((String)name).contains(".")) {
            name = "entity.minecraft." + ((String)name).toLowerCase();
        }
        name = class_1074.method_4662((String)name, (Object[])new Object[0]);
        name = ((String)name).replaceAll("^entity.minecraft.", "");
        name = ((String)name).replace("_", " ");
        name = ((String)name).substring(0, 1).toUpperCase() + ((String)name).substring(1);
        return TextUtils.scrubCodes((String)name);
    }

    public void setSelected(MobItem entry) {
        super.method_25313((class_350.class_351)entry);
        if (this.method_25334() instanceof MobItem) {
            class_333 narratorManager = new class_333(VoxelConstants.getMinecraft());
            narratorManager.method_19788(class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{((MobItem)this.method_25334()).name}).getString());
        }
        this.parentGui.setSelectedMob(entry.id);
    }

    protected boolean method_25332(int index) {
        return ((MobItem)this.mobsFiltered.get((int)index)).id.equals(this.parentGui.selectedMobId);
    }

    protected int method_25317() {
        return this.method_25340() * this.field_22741;
    }

    public void method_25325(class_4587 matrices) {
        this.parentGui.method_25420(matrices);
    }

    protected void updateFilter(String filterString) {
        this.method_25339();
        this.mobsFiltered = new ArrayList<MobItem>(this.mobs);
        Iterator<class_350.class_351<?>> iterator = this.mobsFiltered.iterator();
        while (iterator.hasNext()) {
            String mobName = ((MobItem)iterator.next()).name;
            if (mobName.toLowerCase().contains(filterString)) continue;
            if (mobName.equals(this.parentGui.selectedMobId)) {
                this.parentGui.setSelectedMob(null);
            }
            iterator.remove();
        }
        this.mobsFiltered.forEach((Consumer<class_350.class_351<?>>)((Consumer<class_350.class_351>)x$0 -> this.method_25321((class_350.class_351)x$0)));
    }

    public class MobItem
    extends class_350.class_351<MobItem> {
        private final GuiMobs parentGui;
        private final String id;
        private final String name;

        protected MobItem(GuiMobs mobsScreen, String id) {
            this.parentGui = mobsScreen;
            this.id = id;
            this.name = GuiSlotMobs.getTranslatedName(id);
        }

        public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            boolean isHostile = false;
            boolean isNeutral = false;
            boolean isEnabled = true;
            EnumMobs mob = EnumMobs.getMobByName(this.id);
            if (mob != null) {
                isHostile = mob.isHostile;
                isNeutral = mob.isNeutral;
                isEnabled = mob.enabled;
            } else {
                CustomMob customMob = CustomMobsManager.getCustomMobByType(this.id);
                if (customMob != null) {
                    isHostile = customMob.isHostile;
                    isNeutral = customMob.isNeutral;
                    isEnabled = customMob.enabled;
                }
            }
            int red = isHostile ? 255 : 0;
            int green = isNeutral ? 255 : 0;
            int color = -16777216 + (red << 16) + (green << 8);
            class_332.method_25300((class_4587)matrices, (class_327)this.parentGui.getFontRenderer(), (String)this.name, (int)(this.parentGui.getWidth() / 2), (int)(y + 3), (int)color);
            int padding = 3;
            if (mouseX >= x - padding && mouseY >= y && mouseX <= x + 215 + padding && mouseY <= y + GuiSlotMobs.this.field_22741) {
                class_2561 tooltip = mouseX >= x + 215 - 16 - padding && mouseX <= x + 215 + padding ? (isEnabled ? DISABLE : ENABLE) : (isEnabled ? ENABLED : DISABLED);
                GuiMobs.setTooltip(this.parentGui, tooltip);
            }
            OpenGL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            GLUtils.img2(isEnabled ? GuiSlotMobs.this.visibleIconIdentifier : GuiSlotMobs.this.invisibleIconIdentifier);
            class_332.method_25291((class_4587)matrices, (int)(x + 198), (int)(y - 2), (int)0, (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            GuiSlotMobs.this.setSelected(this);
            int leftEdge = this.parentGui.getWidth() / 2 - 92 - 16;
            int padding = 3;
            int width = 215;
            if (mouseX >= (double)(leftEdge + width - 16 - padding) && mouseX <= (double)(leftEdge + width + padding)) {
                this.parentGui.toggleMobVisibility();
            } else if (GuiSlotMobs.this.doubleclick) {
                this.parentGui.toggleMobVisibility();
            }
            return true;
        }
    }
}

