/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.persistent;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mamiyaotaru.voxelmap.SettingsAndLightingChangeNotifier;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.persistent.CompressibleGLBufferedImage;
import com.mamiyaotaru.voxelmap.persistent.CompressibleMapData;
import com.mamiyaotaru.voxelmap.persistent.EmptyCachedRegion;
import com.mamiyaotaru.voxelmap.persistent.PersistentMap;
import com.mamiyaotaru.voxelmap.persistent.ThreadManager;
import com.mamiyaotaru.voxelmap.util.BlockStateParser;
import com.mamiyaotaru.voxelmap.util.CommandUtils;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.MutableBlockPos;
import com.mamiyaotaru.voxelmap.util.ReflectionUtils;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import net.minecraft.class_1255;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2874;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3898;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import org.apache.logging.log4j.Level;

public class CachedRegion {
    public static final EmptyCachedRegion emptyRegion = new EmptyCachedRegion();
    private long mostRecentView;
    private long mostRecentChange;
    private PersistentMap persistentMap;
    private String key;
    private class_638 world;
    private class_3218 worldServer;
    private class_3215 chunkProvider;
    Class<?> executorClass;
    private class_1255<RefreshRunnable> executor;
    private class_3898 chunkLoader;
    private String subworldName;
    private String worldNamePathPart;
    private String subworldNamePathPart = "";
    private String dimensionNamePathPart;
    private boolean underground;
    private int x;
    private int z;
    private final int width = 256;
    private boolean empty = true;
    private boolean liveChunksUpdated;
    boolean remoteWorld;
    private final boolean[] liveChunkUpdateQueued = new boolean[256];
    private final boolean[] chunkUpdateQueued = new boolean[256];
    private CompressibleGLBufferedImage image;
    private CompressibleMapData data;
    final MutableBlockPos blockPos = new MutableBlockPos(0, 0, 0);
    final MutableBlockPos loopBlockPos = new MutableBlockPos(0, 0, 0);
    Future<?> future;
    private final ReentrantLock threadLock = new ReentrantLock();
    boolean displayOptionsChanged;
    boolean imageChanged;
    boolean refreshQueued;
    boolean refreshingImage;
    boolean dataUpdated;
    boolean dataUpdateQueued;
    boolean loaded;
    boolean closed;
    private static final Object anvilLock = new Object();
    private static final ReadWriteLock tickLock = new ReentrantReadWriteLock();
    private static int loadedChunkCount;
    private boolean queuedToCompress;
    final boolean debug = false;

    public CachedRegion() {
    }

    public CachedRegion(PersistentMap persistentMap, String key, class_638 world, String worldName, String subworldName, int x, int z) {
        this.persistentMap = persistentMap;
        this.key = key;
        this.world = world;
        this.subworldName = subworldName;
        this.worldNamePathPart = TextUtils.scrubNameFile(worldName);
        if (!Objects.equals(subworldName, "")) {
            this.subworldNamePathPart = TextUtils.scrubNameFile(subworldName) + "/";
        }
        String dimensionName = VoxelConstants.getVoxelMapInstance().getDimensionManager().getDimensionContainerByWorld((class_1937)world).getStorageName();
        this.dimensionNamePathPart = TextUtils.scrubNameFile(dimensionName);
        boolean knownUnderground = dimensionName.toLowerCase().contains("erebus");
        this.underground = !world.method_28103().method_28114() && !world.method_8597().comp_642() || world.method_8597().comp_643() || knownUnderground;
        this.remoteWorld = !VoxelConstants.getMinecraft().method_1496();
        persistentMap.getSettingsAndLightingChangeNotifier().addObserver(this);
        this.x = x;
        this.z = z;
        if (!this.remoteWorld) {
            Optional<class_1937> optionalWorld = VoxelConstants.getWorldByKey((class_5321<class_1937>)world.method_27983());
            if (optionalWorld.isEmpty()) {
                String error = "Attempted to fetch World, but none was found!";
                VoxelConstants.getLogger().fatal(error);
                throw new IllegalStateException(error);
            }
            this.worldServer = (class_3218)optionalWorld.get();
            this.chunkProvider = this.worldServer.method_14178();
            this.executorClass = this.chunkProvider.getClass().getDeclaredClasses()[0];
            this.executor = (class_1255)ReflectionUtils.getPrivateFieldValueByType(this.chunkProvider, class_3215.class, this.executorClass);
            this.chunkLoader = this.chunkProvider.field_17254;
        }
        Arrays.fill(this.liveChunkUpdateQueued, false);
        Arrays.fill(this.chunkUpdateQueued, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameSubworld(String oldName, String newName) {
        if (oldName.equals(this.subworldName)) {
            this.closed = true;
            this.threadLock.lock();
            try {
                this.subworldName = newName;
                if (!Objects.equals(this.subworldName, "")) {
                    this.subworldNamePathPart = TextUtils.scrubNameFile(this.subworldName) + "/";
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.threadLock.unlock();
                this.closed = false;
            }
        }
    }

    public void registerChangeAt(int chunkX, int chunkZ) {
        this.dataUpdateQueued = true;
        int index = (chunkZ -= this.z * 16) * 16 + (chunkX -= this.x * 16);
        this.liveChunkUpdateQueued[index] = true;
    }

    public void notifyOfActionableChange(SettingsAndLightingChangeNotifier notifier) {
        this.displayOptionsChanged = true;
    }

    public void refresh(boolean forceCompress) {
        this.mostRecentView = System.currentTimeMillis();
        if (this.future != null && (this.future.isDone() || this.future.isCancelled())) {
            this.refreshQueued = false;
        }
        if (!this.refreshQueued) {
            this.refreshQueued = true;
            if (this.loaded && !this.dataUpdated && !this.dataUpdateQueued && !this.displayOptionsChanged) {
                this.refreshQueued = false;
            } else {
                RefreshRunnable regionProcessingRunnable = new RefreshRunnable(forceCompress);
                this.future = ThreadManager.executorService.submit(regionProcessingRunnable);
            }
        }
    }

    public void handleChangedChunk(class_2818 chunk) {
        int chunkZ = chunk.method_12004().field_9180 - this.z * 16;
        int chunkX = chunk.method_12004().field_9181 - this.x * 16;
        int index = chunkZ * 16 + chunkX;
        if (!this.chunkUpdateQueued[index]) {
            this.chunkUpdateQueued[index] = true;
            this.mostRecentChange = this.mostRecentView = System.currentTimeMillis();
            FillChunkRunnable fillChunkRunnable = new FillChunkRunnable(chunk);
            ThreadManager.executorService.execute(fillChunkRunnable);
        }
    }

    private void load() {
        this.data = new CompressibleMapData(256, 256);
        this.image = new CompressibleGLBufferedImage(256, 256, 6);
        this.loadCachedData();
        this.loadCurrentData(this.world);
        if (!this.remoteWorld) {
            this.loadAnvilData((class_1937)this.world);
        }
        this.loaded = true;
    }

    private void loadCurrentData(class_638 world) {
        for (int chunkX = 0; chunkX < 16; ++chunkX) {
            for (int chunkZ = 0; chunkZ < 16; ++chunkZ) {
                class_2818 chunk = world.method_8497(this.x * 16 + chunkX, this.z * 16 + chunkZ);
                if (chunk == null || chunk.method_12223() || !world.method_8393(this.x * 16 + chunkX, this.z * 16 + chunkZ) || !this.isSurroundedByLoaded(chunk)) continue;
                this.loadChunkData(chunk, chunkX, chunkZ);
            }
        }
    }

    private void loadModifiedData() {
        for (int chunkX = 0; chunkX < 16; ++chunkX) {
            for (int chunkZ = 0; chunkZ < 16; ++chunkZ) {
                if (!this.liveChunkUpdateQueued[chunkZ * 16 + chunkX]) continue;
                this.liveChunkUpdateQueued[chunkZ * 16 + chunkX] = false;
                class_2818 chunk = this.world.method_8497(this.x * 16 + chunkX, this.z * 16 + chunkZ);
                if (chunk == null || chunk.method_12223() || !this.world.method_8393(this.x * 16 + chunkX, this.z * 16 + chunkZ)) continue;
                this.loadChunkData(chunk, chunkX, chunkZ);
            }
        }
    }

    private void loadChunkData(class_2818 chunk, int chunkX, int chunkZ) {
        boolean isEmpty = this.isChunkEmptyOrUnlit(chunk);
        boolean isSurroundedByLoaded = this.isSurroundedByLoaded(chunk);
        if (!this.closed && this.world == GameVariableAccessShim.getWorld() && !isEmpty && isSurroundedByLoaded) {
            this.doLoadChunkData(chunk, chunkX, chunkZ);
        }
    }

    private void loadChunkDataSkipLightCheck(class_2818 chunk, int chunkX, int chunkZ) {
        if (!this.closed && this.world == GameVariableAccessShim.getWorld() && !this.isChunkEmpty(chunk)) {
            this.doLoadChunkData(chunk, chunkX, chunkZ);
        }
    }

    private void doLoadChunkData(class_2818 chunk, int chunkX, int chunkZ) {
        for (int t = 0; t < 16; ++t) {
            for (int s = 0; s < 16; ++s) {
                this.persistentMap.getAndStoreData(this.data, chunk.method_12200(), chunk, this.blockPos, this.underground, this.x * 256, this.z * 256, chunkX * 16 + t, chunkZ * 16 + s);
            }
        }
        this.empty = false;
        this.liveChunksUpdated = true;
        this.dataUpdated = true;
    }

    private boolean isChunkEmptyOrUnlit(class_2818 chunk) {
        return this.closed || chunk.method_12223() || !chunk.method_12009().method_12165(class_2806.field_12803);
    }

    private boolean isChunkEmpty(class_2818 chunk) {
        return this.closed || chunk.method_12223() || !chunk.method_12009().method_12165(class_2806.field_12803);
    }

    public boolean isSurroundedByLoaded(class_2818 chunk) {
        int chunkX = chunk.method_12004().field_9181;
        int chunkZ = chunk.method_12004().field_9180;
        boolean neighborsLoaded = !chunk.method_12223() && VoxelConstants.getPlayer().field_6002.method_8393(chunkX, chunkZ);
        for (int t = chunkX - 1; t <= chunkX + 1 && neighborsLoaded; ++t) {
            for (int s = chunkZ - 1; s <= chunkZ + 1 && neighborsLoaded; ++s) {
                class_2818 neighborChunk = VoxelConstants.getPlayer().field_6002.method_8497(t, s);
                neighborsLoaded = neighborChunk != null && !neighborChunk.method_12223() && VoxelConstants.getPlayer().field_6002.method_8393(t, s);
            }
        }
        return neighborsLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAnvilData(class_1937 world) {
        if (!this.remoteWorld) {
            File directory;
            File regionFile;
            boolean full = true;
            for (int t = 0; t < 16; ++t) {
                for (int s = 0; s < 16; ++s) {
                    if (this.closed || this.data.getHeight(t * 16, s * 16) != 0 || this.data.getLight(t * 16, s * 16) != 0) continue;
                    full = false;
                }
            }
            if (!this.closed && !full && (regionFile = new File(directory = new File(class_2874.method_12488((class_5321)this.worldServer.method_27983(), (Path)this.worldServer.method_8503().method_27050(class_5218.field_24188).normalize()).toString(), "region"), "r." + (int)Math.floor((float)this.x / 2.0f) + "." + (int)Math.floor((float)this.z / 2.0f) + ".mca")).exists()) {
                boolean dataChanged = false;
                boolean loadedChunks = false;
                Object[] chunks = new class_2791[256];
                boolean[] chunkChanged = new boolean[256];
                Arrays.fill(chunks, null);
                Arrays.fill(chunkChanged, false);
                tickLock.readLock().lock();
                try {
                    Object object = anvilLock;
                    synchronized (object) {
                        long loadTime = System.currentTimeMillis();
                        CompletableFuture<Void> loadFuture = CompletableFuture.runAsync(() -> this.lambda$loadAnvilData$1((class_2791[])chunks), this.executor);
                        while (!this.closed && !loadFuture.isDone()) {
                            Thread.onSpinWait();
                        }
                        loadFuture.cancel(false);
                    }
                    long calcTime = System.currentTimeMillis();
                    for (int t = 0; t < 16; ++t) {
                        for (int s = 0; s < 16; ++s) {
                            int index = t + s * 16;
                            if (this.closed || chunks[index] == null) continue;
                            loadedChunks = true;
                            ++loadedChunkCount;
                            class_2818 loadedChunk = null;
                            if (chunks[index] instanceof class_2818) {
                                loadedChunk = (class_2818)chunks[index];
                            } else {
                                VoxelConstants.getLogger().warn("non world chunk at " + chunks[index].method_12004().field_9181 + "," + chunks[index].method_12004().field_9180);
                            }
                            if (!this.closed && loadedChunk != null && loadedChunk.method_12009().method_12165(class_2806.field_12803)) {
                                CompletableFuture lightFuture = this.chunkProvider.method_17293().method_17310((class_2791)loadedChunk, false);
                                while (!this.closed && !lightFuture.isDone()) {
                                    Thread.onSpinWait();
                                }
                                loadedChunk = lightFuture.getNow(loadedChunk);
                                lightFuture.cancel(false);
                            }
                            if (this.closed || loadedChunk == null || !loadedChunk.method_12009().method_12165(class_2806.field_12803)) continue;
                            this.loadChunkDataSkipLightCheck(loadedChunk, t, s);
                            dataChanged = true;
                        }
                    }
                }
                catch (Exception var41) {
                    VoxelConstants.getLogger().warn("error in anvil loading");
                }
                finally {
                    tickLock.readLock().unlock();
                }
                if (!this.closed && dataChanged) {
                    this.saveData(false);
                }
                if (!this.closed && loadedChunks && loadedChunkCount > 4096) {
                    loadedChunkCount = 0;
                    tickLock.writeLock().lock();
                    try {
                        CompletableFuture<Void> tickFuture = CompletableFuture.runAsync(() -> this.chunkProvider.method_12127(() -> true, this.executor.method_18854()));
                        long tickTime = System.currentTimeMillis();
                        while (!this.closed && !tickFuture.isDone()) {
                            Thread.onSpinWait();
                        }
                    }
                    catch (RuntimeException var38) {
                        VoxelConstants.getLogger().warn("error ticking from anvil loading");
                    }
                    finally {
                        tickLock.writeLock().unlock();
                    }
                }
            }
        }
    }

    private void loadCachedData() {
        block10: {
            try {
                int count;
                File cachedRegionFileDir = new File(VoxelConstants.getMinecraft().field_1697, "/voxelmap/cache/" + this.worldNamePathPart + "/" + this.subworldNamePathPart + this.dimensionNamePathPart);
                cachedRegionFileDir.mkdirs();
                File cachedRegionFile = new File(cachedRegionFileDir, "/" + this.key + ".zip");
                if (!cachedRegionFile.exists()) break block10;
                ZipFile zFile = new ZipFile(cachedRegionFile);
                int total = 0;
                byte[] decompressedByteData = new byte[this.data.getWidth() * this.data.getHeight() * 17 * 4];
                ZipEntry ze = zFile.getEntry("data");
                InputStream is = zFile.getInputStream(ze);
                byte[] byteData = new byte[2048];
                while ((count = is.read(byteData, 0, 2048)) != -1 && count + total <= this.data.getWidth() * this.data.getHeight() * 17 * 4) {
                    System.arraycopy(byteData, 0, decompressedByteData, total, count);
                    total += count;
                }
                is.close();
                ze = zFile.getEntry("key");
                is = zFile.getInputStream(ze);
                HashBiMap var18 = HashBiMap.create();
                Scanner sc = new Scanner(is);
                while (sc.hasNextLine()) {
                    BlockStateParser.parseLine(sc.nextLine(), (BiMap<class_2680, Integer>)var18);
                }
                sc.close();
                is.close();
                int version = 1;
                ze = zFile.getEntry("control");
                if (ze != null && (is = zFile.getInputStream(ze)) != null) {
                    Properties properties = new Properties();
                    properties.load(is);
                    String versionString = properties.getProperty("version", "1");
                    try {
                        version = Integer.parseInt(versionString);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    is.close();
                }
                zFile.close();
                if (total == this.data.getWidth() * this.data.getHeight() * 18) {
                    byte[] var23 = new byte[this.data.getWidth() * this.data.getHeight() * 18];
                    System.arraycopy(decompressedByteData, 0, var23, 0, var23.length);
                    this.data.setData(var23, (BiMap<class_2680, Integer>)var18, version);
                    this.empty = false;
                    this.dataUpdated = true;
                } else {
                    VoxelConstants.getLogger().warn("failed to load data from " + cachedRegionFile.getPath());
                }
                if (version < 2) {
                    this.liveChunksUpdated = true;
                }
            }
            catch (IOException var17) {
                VoxelConstants.getLogger().error("Failed to load region file for " + this.x + "," + this.z + " in " + this.worldNamePathPart + "/" + this.subworldNamePathPart + this.dimensionNamePathPart, (Throwable)var17);
            }
        }
    }

    private void saveData(boolean newThread) {
        if (this.liveChunksUpdated && !this.worldNamePathPart.isEmpty()) {
            if (newThread) {
                ThreadManager.executorService.execute(() -> {
                    this.threadLock.lock();
                    try {
                        this.doSave();
                    }
                    catch (IOException var5) {
                        VoxelConstants.getLogger().error("Failed to save region file for " + this.x + "," + this.z + " in " + this.worldNamePathPart + "/" + this.subworldNamePathPart + this.dimensionNamePathPart, (Throwable)var5);
                    }
                    finally {
                        this.threadLock.unlock();
                    }
                });
            } else {
                try {
                    this.doSave();
                }
                catch (IOException var3) {
                    VoxelConstants.getLogger().error((Object)var3);
                }
            }
            this.liveChunksUpdated = false;
        }
    }

    private void doSave() throws IOException {
        int var10001;
        BiMap<class_2680, Integer> stateToInt = this.data.getStateToInt();
        byte[] byteArray = this.data.getData();
        int var10000 = byteArray.length;
        if (var10000 == (var10001 = this.data.getWidth() * this.data.getHeight()) * 18) {
            File cachedRegionFileDir = new File(VoxelConstants.getMinecraft().field_1697, "/voxelmap/cache/" + this.worldNamePathPart + "/" + this.subworldNamePathPart + this.dimensionNamePathPart);
            cachedRegionFileDir.mkdirs();
            File cachedRegionFile = new File(cachedRegionFileDir, "/" + this.key + ".zip");
            FileOutputStream fos = new FileOutputStream(cachedRegionFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            ZipEntry ze = new ZipEntry("data");
            ze.setSize(byteArray.length);
            zos.putNextEntry(ze);
            zos.write(byteArray);
            zos.closeEntry();
            if (stateToInt != null) {
                Iterator iterator = stateToInt.entrySet().iterator();
                StringBuilder stringBuffer = new StringBuilder();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    String nextLine = entry.getValue() + " " + ((class_2680)entry.getKey()).toString() + "\r\n";
                    stringBuffer.append(nextLine);
                }
                byte[] keyByteArray = String.valueOf(stringBuffer).getBytes();
                ze = new ZipEntry("key");
                ze.setSize(keyByteArray.length);
                zos.putNextEntry(ze);
                zos.write(keyByteArray);
                zos.closeEntry();
            }
            String nextLine = "version:2\r\n";
            byte[] keyByteArray = nextLine.getBytes();
            ze = new ZipEntry("control");
            ze.setSize(keyByteArray.length);
            zos.putNextEntry(ze);
            zos.write(keyByteArray);
            zos.closeEntry();
            zos.close();
            fos.close();
        } else {
            VoxelConstants.getLogger().warn("Data array wrong size: " + byteArray.length + "for " + this.x + "," + this.z + " in " + this.worldNamePathPart + "/" + this.subworldNamePathPart + this.dimensionNamePathPart);
        }
    }

    private void fillImage() {
        for (int t = 0; t < 256; ++t) {
            for (int s = 0; s < 256; ++s) {
                int color24 = this.persistentMap.getPixelColor(this.data, this.world, this.blockPos, this.loopBlockPos, this.underground, 8, this.x * 256, this.z * 256, t, s);
                this.image.setRGB(t, s, color24);
            }
        }
    }

    private void saveImage() {
        if (!this.empty) {
            File imageFileDir = new File(VoxelConstants.getMinecraft().field_1697, "/voxelmap/cache/" + this.worldNamePathPart + "/" + this.subworldNamePathPart + this.dimensionNamePathPart + "/images/z1");
            imageFileDir.mkdirs();
            File imageFile = new File(imageFileDir, this.key + ".png");
            if (this.liveChunksUpdated || !imageFile.exists()) {
                ThreadManager.executorService.execute(() -> {
                    this.threadLock.lock();
                    try {
                        BufferedImage realBufferedImage = new BufferedImage(this.width, this.width, 6);
                        byte[] dstArray = ((DataBufferByte)realBufferedImage.getRaster().getDataBuffer()).getData();
                        System.arraycopy(this.image.getData(), 0, dstArray, 0, this.image.getData().length);
                        ImageIO.write((RenderedImage)realBufferedImage, "png", imageFile);
                    }
                    catch (IOException var6) {
                        VoxelConstants.getLogger().error((Object)var6);
                    }
                    finally {
                        this.threadLock.unlock();
                    }
                });
            }
        }
    }

    public long getMostRecentView() {
        return this.mostRecentView;
    }

    public long getMostRecentChange() {
        return this.mostRecentChange;
    }

    public String getKey() {
        return this.key;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public int getWidth() {
        return this.width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGLID() {
        if (this.image != null) {
            if (!this.refreshingImage) {
                CompressibleGLBufferedImage compressibleGLBufferedImage = this.image;
                synchronized (compressibleGLBufferedImage) {
                    if (this.imageChanged) {
                        this.imageChanged = false;
                        this.image.write();
                    }
                }
            }
            return this.image.getIndex();
        }
        return 0;
    }

    public CompressibleMapData getMapData() {
        return this.data;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isGroundAt(int blockX, int blockZ) {
        return this.isLoaded() && this.getHeightAt(blockX, blockZ) > 0;
    }

    public int getHeightAt(int blockX, int blockZ) {
        int y;
        int x = blockX - this.x * 256;
        int z = blockZ - this.z * 256;
        int n = y = this.data == null ? 0 : this.data.getHeight(x, z);
        if (this.underground && y == 255) {
            y = CommandUtils.getSafeHeight(blockX, 64, blockZ, (class_1937)this.world);
        }
        return y;
    }

    public void compress() {
        if (this.data != null && !this.isCompressed() && !this.queuedToCompress) {
            this.queuedToCompress = true;
            ThreadManager.executorService.execute(() -> {
                if (this.threadLock.tryLock()) {
                    try {
                        this.compressData();
                    }
                    catch (RuntimeException runtimeException) {
                    }
                    finally {
                        this.threadLock.unlock();
                    }
                }
                this.queuedToCompress = false;
            });
        }
    }

    private void compressData() {
        this.data.compress();
    }

    private boolean isCompressed() {
        return this.data.isCompressed();
    }

    public void cleanup() {
        this.closed = true;
        this.queuedToCompress = true;
        if (this.future != null) {
            this.future.cancel(false);
        }
        this.persistentMap.getSettingsAndLightingChangeNotifier().removeObserver(this);
        if (this.image != null) {
            this.image.baleet();
        }
        this.saveData(true);
        if (this.persistentMap.getOptions().outputImages) {
            this.saveImage();
        }
    }

    private /* synthetic */ void lambda$loadAnvilData$1(class_2791[] chunks) {
        for (int tx = 0; tx < 16; ++tx) {
            for (int sx = 0; sx < 16; ++sx) {
                class_2499 sections;
                if (this.closed || this.data.getHeight(tx * 16, sx * 16) != 0 || this.data.getLight(tx * 16, sx * 16) != 0) continue;
                int index = tx + sx * 16;
                class_1923 chunkPos = new class_1923(this.x * 16 + tx, this.z * 16 + sx);
                class_2487 rawNbt = (class_2487)((Optional)this.chunkLoader.method_23696(chunkPos).join()).get();
                class_2487 nbt = this.chunkLoader.method_17907(this.worldServer.method_27983(), () -> this.worldServer.method_17983(), rawNbt, Optional.empty());
                if (this.closed || !nbt.method_10573("Level", 10)) continue;
                class_2487 level = nbt.method_10562("Level");
                int chunkX = level.method_10550("xPos");
                int chunkZ = level.method_10550("zPos");
                if (chunkPos.field_9181 != chunkX || chunkPos.field_9180 != chunkZ || !level.method_10573("Status", 8) || !class_2806.method_12168((String)level.method_10558("Status")).method_12165(class_2806.field_12786) || !level.method_10545("Sections") || (sections = level.method_10554("Sections", 10)).isEmpty()) continue;
                boolean hasInfo = false;
                for (int i = 0; i < sections.size() && !hasInfo && !this.closed; ++i) {
                    class_2487 section = sections.method_10602(i);
                    if (!section.method_10573("Palette", 9) || !section.method_10573("BlockStates", 12)) continue;
                    hasInfo = true;
                }
                if (!hasInfo) continue;
                chunks[index] = this.worldServer.method_8497(chunkPos.field_9181, chunkPos.field_9180);
            }
        }
    }

    private final class RefreshRunnable
    implements Runnable {
        private final boolean forceCompress;

        private RefreshRunnable(boolean forceCompress) {
            this.forceCompress = forceCompress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CachedRegion.this.mostRecentChange = System.currentTimeMillis();
            CachedRegion.this.threadLock.lock();
            try {
                if (!CachedRegion.this.loaded) {
                    CachedRegion.this.load();
                }
                if (CachedRegion.this.dataUpdateQueued) {
                    CachedRegion.this.loadModifiedData();
                    CachedRegion.this.dataUpdateQueued = false;
                }
                while (CachedRegion.this.dataUpdated || CachedRegion.this.displayOptionsChanged) {
                    CachedRegion.this.dataUpdated = false;
                    CachedRegion.this.displayOptionsChanged = false;
                    CachedRegion.this.refreshingImage = true;
                    CompressibleGLBufferedImage compressibleGLBufferedImage = CachedRegion.this.image;
                    synchronized (compressibleGLBufferedImage) {
                        CachedRegion.this.fillImage();
                        CachedRegion.this.imageChanged = true;
                    }
                    CachedRegion.this.refreshingImage = false;
                }
                if (this.forceCompress) {
                    CachedRegion.this.compressData();
                }
            }
            catch (Exception var8) {
                VoxelConstants.getLogger().error("Exception loading region: " + var8.getLocalizedMessage(), (Throwable)var8);
            }
            finally {
                CachedRegion.this.threadLock.unlock();
                CachedRegion.this.refreshQueued = false;
            }
        }
    }

    private final class FillChunkRunnable
    implements Runnable {
        private final class_2818 chunk;
        private final int index;

        private FillChunkRunnable(class_2818 chunk) {
            this.chunk = chunk;
            int chunkX = chunk.method_12004().field_9181 - CachedRegion.this.x * 16;
            int chunkZ = chunk.method_12004().field_9180 - CachedRegion.this.z * 16;
            this.index = chunkZ * 16 + chunkX;
        }

        @Override
        public void run() {
            CachedRegion.this.threadLock.lock();
            try {
                if (!CachedRegion.this.loaded) {
                    CachedRegion.this.load();
                }
                int chunkX = this.chunk.method_12004().field_9181 - CachedRegion.this.x * 16;
                int chunkZ = this.chunk.method_12004().field_9180 - CachedRegion.this.z * 16;
                CachedRegion.this.loadChunkData(this.chunk, chunkX, chunkZ);
            }
            catch (Exception ex) {
                VoxelConstants.getLogger().log(Level.ERROR, "Error in FillChunkRunnable", (Throwable)ex);
            }
            finally {
                CachedRegion.this.threadLock.unlock();
                CachedRegion.this.chunkUpdateQueued[this.index] = false;
            }
        }
    }
}

