/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.persistent;

import com.mamiyaotaru.voxelmap.ColorManager;
import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.SettingsAndLightingChangeNotifier;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.interfaces.AbstractMapData;
import com.mamiyaotaru.voxelmap.interfaces.IChangeObserver;
import com.mamiyaotaru.voxelmap.persistent.CachedRegion;
import com.mamiyaotaru.voxelmap.persistent.GuiPersistentMap;
import com.mamiyaotaru.voxelmap.persistent.PersistentMapSettingsManager;
import com.mamiyaotaru.voxelmap.persistent.ThreadManager;
import com.mamiyaotaru.voxelmap.persistent.WorldMatcher;
import com.mamiyaotaru.voxelmap.util.BiomeRepository;
import com.mamiyaotaru.voxelmap.util.BlockRepository;
import com.mamiyaotaru.voxelmap.util.ColorUtils;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.MapChunkCache;
import com.mamiyaotaru.voxelmap.util.MapUtils;
import com.mamiyaotaru.voxelmap.util.MutableBlockPos;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.IntStream;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2368;
import net.minecraft.class_2506;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3614;
import net.minecraft.class_638;
import net.minecraft.class_7924;

public class PersistentMap
implements IChangeObserver {
    final MutableBlockPos blockPos = new MutableBlockPos(0, 0, 0);
    final ColorManager colorManager;
    final MapSettingsManager mapOptions;
    final PersistentMapSettingsManager options;
    WorldMatcher worldMatcher;
    final int[] lightmapColors;
    class_638 world;
    String subworldName = "";
    protected final List<CachedRegion> cachedRegionsPool = Collections.synchronizedList(new ArrayList());
    protected final ConcurrentHashMap<String, CachedRegion> cachedRegions = new ConcurrentHashMap(150, 0.9f, 2);
    int lastLeft;
    int lastRight;
    int lastTop;
    int lastBottom;
    CachedRegion[] lastRegionsArray = new CachedRegion[0];
    final Comparator<CachedRegion> ageThenDistanceSorter = (region1, region2) -> {
        long mostRecentAccess2;
        long mostRecentAccess1 = region1.getMostRecentView();
        if (mostRecentAccess1 < (mostRecentAccess2 = region2.getMostRecentView())) {
            return 1;
        }
        if (mostRecentAccess1 > mostRecentAccess2) {
            return -1;
        }
        double distance1sq = ((float)(region1.getX() * 256) + (float)region1.getWidth() / 2.0f - (float)this.options.mapX) * ((float)(region1.getX() * 256) + (float)region1.getWidth() / 2.0f - (float)this.options.mapX) + ((float)(region1.getZ() * 256) + (float)region1.getWidth() / 2.0f - (float)this.options.mapZ) * ((float)(region1.getZ() * 256) + (float)region1.getWidth() / 2.0f - (float)this.options.mapZ);
        double distance2sq = ((float)(region2.getX() * 256) + (float)region2.getWidth() / 2.0f - (float)this.options.mapX) * ((float)(region2.getX() * 256) + (float)region2.getWidth() / 2.0f - (float)this.options.mapX) + ((float)(region2.getZ() * 256) + (float)region2.getWidth() / 2.0f - (float)this.options.mapZ) * ((float)(region2.getZ() * 256) + (float)region2.getWidth() / 2.0f - (float)this.options.mapZ);
        return Double.compare(distance1sq, distance2sq);
    };
    final Comparator<RegionCoordinates> distanceSorter = (coordinates1, coordinates2) -> {
        double distance1sq = (coordinates1.x * 256 + 128 - this.options.mapX) * (coordinates1.x * 256 + 128 - this.options.mapX) + (coordinates1.z * 256 + 128 - this.options.mapZ) * (coordinates1.z * 256 + 128 - this.options.mapZ);
        double distance2sq = (coordinates2.x * 256 + 128 - this.options.mapX) * (coordinates2.x * 256 + 128 - this.options.mapX) + (coordinates2.z * 256 + 128 - this.options.mapZ) * (coordinates2.z * 256 + 128 - this.options.mapZ);
        return Double.compare(distance1sq, distance2sq);
    };
    private boolean queuedChangedChunks;
    private MapChunkCache chunkCache;
    private final ConcurrentLinkedQueue<ChunkWithAge> chunkUpdateQueue = new ConcurrentLinkedQueue();

    public PersistentMap() {
        this.colorManager = VoxelConstants.getVoxelMapInstance().getColorManager();
        this.mapOptions = VoxelConstants.getVoxelMapInstance().getMapOptions();
        this.options = VoxelConstants.getVoxelMapInstance().getPersistentMapOptions();
        this.lightmapColors = new int[256];
        Arrays.fill(this.lightmapColors, -16777216);
    }

    public void newWorld(class_638 world) {
        this.subworldName = "";
        this.purgeCachedRegions();
        this.queuedChangedChunks = false;
        this.chunkUpdateQueue.clear();
        this.world = world;
        if (this.worldMatcher != null) {
            this.worldMatcher.cancel();
        }
        if (world != null) {
            this.newWorldStuff();
        } else {
            Thread pauseForSubworldNamesThread = new Thread(null, null, "VoxelMap Pause for Subworld Name Thread"){

                @Override
                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException var2) {
                        VoxelConstants.getLogger().error((Object)var2);
                    }
                    if (PersistentMap.this.world != null) {
                        PersistentMap.this.newWorldStuff();
                    }
                }
            };
            pauseForSubworldNamesThread.start();
        }
    }

    private void newWorldStuff() {
        String worldName = TextUtils.scrubNameFile(VoxelConstants.getVoxelMapInstance().getWaypointManager().getCurrentWorldName());
        File oldCacheDir = new File(VoxelConstants.getMinecraft().field_1697, "/mods/mamiyaotaru/voxelmap/cache/" + worldName + "/");
        if (oldCacheDir.exists() && oldCacheDir.isDirectory()) {
            File newCacheDir = new File(VoxelConstants.getMinecraft().field_1697, "/voxelmap/cache/" + worldName + "/");
            newCacheDir.getParentFile().mkdirs();
            boolean success = oldCacheDir.renameTo(newCacheDir);
            if (!success) {
                VoxelConstants.getLogger().warn("Failed moving Voxelmap cache files.  Please move " + oldCacheDir.getPath() + " to " + newCacheDir.getPath());
            } else {
                VoxelConstants.getLogger().warn("Moved Voxelmap cache files from " + oldCacheDir.getPath() + " to " + newCacheDir.getPath());
            }
        }
        if (VoxelConstants.getVoxelMapInstance().getWaypointManager().isMultiworld() && !VoxelConstants.getMinecraft().method_1542() && !VoxelConstants.getVoxelMapInstance().getWaypointManager().receivedAutoSubworldName()) {
            this.worldMatcher = new WorldMatcher(this, this.world);
            this.worldMatcher.findMatch();
        }
        this.chunkCache = new MapChunkCache(33, 33, this);
    }

    public void onTick() {
        if (VoxelConstants.getMinecraft().field_1755 == null) {
            this.options.mapX = GameVariableAccessShim.xCoord();
            this.options.mapZ = GameVariableAccessShim.zCoord();
        }
        if (!VoxelConstants.getVoxelMapInstance().getWaypointManager().getCurrentSubworldDescriptor(false).equals(this.subworldName)) {
            this.subworldName = VoxelConstants.getVoxelMapInstance().getWaypointManager().getCurrentSubworldDescriptor(false);
            if (this.worldMatcher != null && !this.subworldName.isEmpty()) {
                this.worldMatcher.cancel();
            }
            this.purgeCachedRegions();
        }
        if (this.queuedChangedChunks) {
            this.queuedChangedChunks = false;
            this.prunePool();
        }
        if (this.world != null) {
            this.chunkCache.centerChunks(this.blockPos.withXYZ(GameVariableAccessShim.xCoord(), 0, GameVariableAccessShim.zCoord()));
            this.chunkCache.checkIfChunksBecameSurroundedByLoaded();
            while (!this.chunkUpdateQueue.isEmpty() && Math.abs(VoxelConstants.getElapsedTicks() - this.chunkUpdateQueue.peek().tick) >= 20) {
                this.doProcessChunk(((ChunkWithAge)this.chunkUpdateQueue.remove()).chunk);
            }
        }
    }

    public PersistentMapSettingsManager getOptions() {
        return this.options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeCachedRegions() {
        List<CachedRegion> list = this.cachedRegionsPool;
        synchronized (list) {
            for (CachedRegion cachedRegion : this.cachedRegionsPool) {
                cachedRegion.cleanup();
            }
            this.cachedRegions.clear();
            this.cachedRegionsPool.clear();
            this.getRegions(0, -1, 0, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameSubworld(String oldName, String newName) {
        List<CachedRegion> list = this.cachedRegionsPool;
        synchronized (list) {
            for (CachedRegion cachedRegion : this.cachedRegionsPool) {
                cachedRegion.renameSubworld(oldName, newName);
            }
        }
    }

    public SettingsAndLightingChangeNotifier getSettingsAndLightingChangeNotifier() {
        return VoxelConstants.getVoxelMapInstance().getSettingsAndLightingChangeNotifier();
    }

    public void setLightMapArray(int[] lights) {
        int torchOffset = 0;
        int skylightMultiplier = 16;
        boolean changed = IntStream.range(0, 16).anyMatch(t -> lights[t * skylightMultiplier + torchOffset] != this.lightmapColors[t * skylightMultiplier + torchOffset]);
        System.arraycopy(lights, 0, this.lightmapColors, 0, 256);
        if (changed) {
            this.getSettingsAndLightingChangeNotifier().notifyOfChanges();
        }
    }

    public void getAndStoreData(AbstractMapData mapData, class_1937 world, class_2818 chunk, MutableBlockPos pos, boolean underground, int startX, int startZ, int imageX, int imageY) {
        int seafloorHeight = 0;
        int transparentHeight = 0;
        int foliageHeight = 0;
        class_2680 transparentBlockState = BlockRepository.air.method_9564();
        class_2680 foliageBlockState = BlockRepository.air.method_9564();
        class_2680 seafloorBlockState = BlockRepository.air.method_9564();
        pos = pos.withXYZ(startX + imageX, 64, startZ + imageY);
        int biomeID = !chunk.method_12223() ? world.method_30349().method_30530(class_7924.field_41236).method_10206((Object)((class_1959)world.method_23753((class_2338)pos).comp_349())) : -1;
        mapData.setBiomeID(imageX, imageY, biomeID);
        if (biomeID != -1) {
            int light;
            class_2680 surfaceBlockState;
            int surfaceHeight;
            boolean solid = false;
            if (underground) {
                surfaceHeight = this.getNetherHeight(chunk, startX + imageX, startZ + imageY);
                surfaceBlockState = chunk.method_8320((class_2338)pos.withXYZ(startX + imageX, surfaceHeight - 1, startZ + imageY));
                if (surfaceHeight != -1) {
                    foliageHeight = surfaceHeight + 1;
                    pos.setXYZ(startX + imageX, foliageHeight - 1, startZ + imageY);
                    foliageBlockState = chunk.method_8320((class_2338)pos);
                    class_3614 material = foliageBlockState.method_26207();
                    if (material == class_3614.field_15948 || material == class_3614.field_15959 || material == class_3614.field_15922 || material == class_3614.field_15920) {
                        foliageHeight = 0;
                    }
                }
            } else {
                class_265 voxelShape;
                boolean hasOpacity;
                transparentHeight = chunk.method_12005(class_2902.class_2903.field_13197, pos.method_10263() & 0xF, pos.method_10260() & 0xF) + 1;
                transparentBlockState = chunk.method_8320((class_2338)pos.withXYZ(startX + imageX, transparentHeight - 1, startZ + imageY));
                class_3610 fluidState = transparentBlockState.method_26227();
                if (fluidState != class_3612.field_15906.method_15785()) {
                    transparentBlockState = fluidState.method_15759();
                }
                surfaceHeight = transparentHeight;
                surfaceBlockState = transparentBlockState;
                boolean bl = hasOpacity = transparentBlockState.method_26193((class_1922)world, (class_2338)pos) > 0;
                if (!hasOpacity && transparentBlockState.method_26225() && transparentBlockState.method_26211()) {
                    voxelShape = transparentBlockState.method_26173((class_1922)world, (class_2338)pos, class_2350.field_11033);
                    hasOpacity = class_259.method_20713((class_265)voxelShape, (class_265)class_259.method_1073());
                    voxelShape = transparentBlockState.method_26173((class_1922)world, (class_2338)pos, class_2350.field_11036);
                    boolean bl2 = hasOpacity = hasOpacity || class_259.method_20713((class_265)class_259.method_1073(), (class_265)voxelShape);
                }
                while (!hasOpacity && surfaceHeight > 0) {
                    foliageBlockState = surfaceBlockState;
                    if ((fluidState = (surfaceBlockState = chunk.method_8320((class_2338)pos.withXYZ(startX + imageX, --surfaceHeight - 1, startZ + imageY))).method_26227()) != class_3612.field_15906.method_15785()) {
                        surfaceBlockState = fluidState.method_15759();
                    }
                    if ((hasOpacity = surfaceBlockState.method_26193((class_1922)world, (class_2338)pos) > 0) || !surfaceBlockState.method_26225() || !surfaceBlockState.method_26211()) continue;
                    voxelShape = surfaceBlockState.method_26173((class_1922)world, (class_2338)pos, class_2350.field_11033);
                    hasOpacity = class_259.method_20713((class_265)voxelShape, (class_265)class_259.method_1073());
                    voxelShape = surfaceBlockState.method_26173((class_1922)world, (class_2338)pos, class_2350.field_11036);
                    hasOpacity = hasOpacity || class_259.method_20713((class_265)class_259.method_1073(), (class_265)voxelShape);
                }
                if (surfaceHeight == transparentHeight) {
                    transparentHeight = 0;
                    transparentBlockState = BlockRepository.air.method_9564();
                    foliageBlockState = chunk.method_8320((class_2338)pos.withXYZ(startX + imageX, surfaceHeight, startZ + imageY));
                }
                if (foliageBlockState.method_26207() == class_3614.field_15948) {
                    surfaceBlockState = foliageBlockState;
                    foliageBlockState = BlockRepository.air.method_9564();
                }
                if (foliageBlockState == transparentBlockState) {
                    foliageBlockState = BlockRepository.air.method_9564();
                }
                if (foliageBlockState != null && foliageBlockState.method_26207() != class_3614.field_15959) {
                    foliageHeight = surfaceHeight + 1;
                } else {
                    foliageBlockState = BlockRepository.air.method_9564();
                }
                class_3614 material = surfaceBlockState.method_26207();
                if (material == class_3614.field_15920 || material == class_3614.field_15958) {
                    seafloorHeight = surfaceHeight;
                    seafloorBlockState = chunk.method_8320((class_2338)pos.withXYZ(startX + imageX, surfaceHeight - 1, startZ + imageY));
                    while (seafloorBlockState.method_26193((class_1922)world, (class_2338)pos) < 5 && seafloorBlockState.method_26207() != class_3614.field_15923 && seafloorHeight > 1) {
                        material = seafloorBlockState.method_26207();
                        if (transparentHeight == 0 && material != class_3614.field_15958 && material != class_3614.field_15920 && material.method_15801()) {
                            transparentHeight = seafloorHeight;
                            transparentBlockState = seafloorBlockState;
                        }
                        if (foliageHeight == 0 && seafloorHeight != transparentHeight && transparentBlockState != seafloorBlockState && material != class_3614.field_15958 && material != class_3614.field_15920 && material != class_3614.field_15959 && material != class_3614.field_15915) {
                            foliageHeight = seafloorHeight;
                            foliageBlockState = seafloorBlockState;
                        }
                        seafloorBlockState = chunk.method_8320((class_2338)pos.withXYZ(startX + imageX, --seafloorHeight - 1, startZ + imageY));
                    }
                    if (seafloorBlockState.method_26207() == class_3614.field_15920) {
                        seafloorBlockState = BlockRepository.air.method_9564();
                    }
                }
            }
            mapData.setHeight(imageX, imageY, surfaceHeight);
            mapData.setBlockstate(imageX, imageY, surfaceBlockState);
            mapData.setTransparentHeight(imageX, imageY, transparentHeight);
            mapData.setTransparentBlockstate(imageX, imageY, transparentBlockState);
            mapData.setFoliageHeight(imageX, imageY, foliageHeight);
            mapData.setFoliageBlockstate(imageX, imageY, foliageBlockState);
            mapData.setOceanFloorHeight(imageX, imageY, seafloorHeight);
            mapData.setOceanFloorBlockstate(imageX, imageY, seafloorBlockState);
            if (surfaceHeight == -1) {
                surfaceHeight = 80;
                solid = true;
            }
            if (surfaceBlockState.method_26207() == class_3614.field_15922) {
                solid = false;
            }
            int n = light = solid ? 0 : 255;
            if (!solid) {
                light = this.getLight(surfaceBlockState, world, pos, startX + imageX, startZ + imageY, surfaceHeight, solid);
            }
            mapData.setLight(imageX, imageY, light);
            int seafloorLight = 0;
            if (seafloorBlockState != null && seafloorBlockState != BlockRepository.air.method_9564()) {
                seafloorLight = this.getLight(seafloorBlockState, world, pos, startX + imageX, startZ + imageY, seafloorHeight, solid);
            }
            mapData.setOceanFloorLight(imageX, imageY, seafloorLight);
            int transparentLight = 0;
            if (transparentBlockState != null && transparentBlockState != BlockRepository.air.method_9564()) {
                transparentLight = this.getLight(transparentBlockState, world, pos, startX + imageX, startZ + imageY, transparentHeight, solid);
            }
            mapData.setTransparentLight(imageX, imageY, transparentLight);
            int foliageLight = 0;
            if (foliageBlockState != null && foliageBlockState != BlockRepository.air.method_9564()) {
                foliageLight = this.getLight(foliageBlockState, world, pos, startX + imageX, startZ + imageY, foliageHeight, solid);
            }
            mapData.setFoliageLight(imageX, imageY, foliageLight);
        }
    }

    private int getNetherHeight(class_2818 chunk, int x, int z) {
        int y = 80;
        this.blockPos.setXYZ(x, y, z);
        class_2680 blockState = chunk.method_8320((class_2338)this.blockPos);
        if (blockState.method_26193((class_1922)this.world, (class_2338)this.blockPos) == 0 && blockState.method_26207() != class_3614.field_15922) {
            while (y > 0) {
                this.blockPos.setXYZ(x, --y, z);
                blockState = chunk.method_8320((class_2338)this.blockPos);
                if (blockState.method_26193((class_1922)this.world, (class_2338)this.blockPos) <= 0 && blockState.method_26207() != class_3614.field_15922) continue;
                return y + 1;
            }
            return y;
        }
        while (y <= 90) {
            this.blockPos.setXYZ(x, ++y, z);
            blockState = chunk.method_8320((class_2338)this.blockPos);
            if (blockState.method_26193((class_1922)this.world, (class_2338)this.blockPos) != 0 || blockState.method_26207() == class_3614.field_15922) continue;
            return y;
        }
        return -1;
    }

    private int getLight(class_2680 blockState, class_1937 world, MutableBlockPos blockPos, int x, int z, int height, boolean solid) {
        int i3 = 255;
        if (solid) {
            i3 = 0;
        } else if (blockState != null && blockState.method_26207() != class_3614.field_15959) {
            blockPos.setXYZ(x, Math.max(Math.min(height, 255), 0), z);
            int blockLight = world.method_8314(class_1944.field_9282, (class_2338)blockPos) & 0xF;
            int skyLight = world.method_8314(class_1944.field_9284, (class_2338)blockPos);
            if (blockState.method_26207() == class_3614.field_15922 || blockState.method_26204() == class_2246.field_10092) {
                blockLight = 14;
            }
            i3 = blockLight + skyLight * 16;
        }
        return i3;
    }

    public int getPixelColor(AbstractMapData mapData, class_638 world, MutableBlockPos blockPos, MutableBlockPos loopBlockPos, boolean underground, int multi, int startX, int startZ, int imageX, int imageY) {
        int mcX = startX + imageX;
        int mcZ = startZ + imageY;
        int seafloorHeight = 0;
        int transparentHeight = 0;
        int foliageHeight = 0;
        int seafloorColor = 0;
        int transparentColor = 0;
        int foliageColor = 0;
        blockPos = blockPos.withXYZ(mcX, 0, mcZ);
        int biomeID = mapData.getBiomeID(imageX, imageY);
        class_2680 surfaceBlockState = mapData.getBlockstate(imageX, imageY);
        if (surfaceBlockState != null && (surfaceBlockState.method_26204() != BlockRepository.air || mapData.getLight(imageX, imageY) != 0 || mapData.getHeight(imageX, imageY) != 0) && biomeID != -1 && biomeID != 255) {
            int color24;
            if (this.mapOptions.biomeOverlay == 1) {
                color24 = biomeID >= 0 ? BiomeRepository.getBiomeColor(biomeID) | 0xFF000000 : 0;
            } else {
                int lightValue;
                int tint;
                int surfaceColor;
                boolean solid = false;
                int surfaceHeight = mapData.getHeight(imageX, imageY);
                int blockStateID = BlockRepository.getStateId(surfaceBlockState);
                if (surfaceHeight == -1 || surfaceHeight == 255) {
                    surfaceHeight = 80;
                    solid = true;
                }
                blockPos.setXYZ(mcX, surfaceHeight - 1, mcZ);
                if (surfaceBlockState.method_26207() == class_3614.field_15922) {
                    solid = false;
                }
                if (this.mapOptions.biomes) {
                    surfaceColor = this.colorManager.getBlockColor(blockPos, blockStateID, biomeID);
                    int tint2 = this.colorManager.getBiomeTint(mapData, (class_1937)world, surfaceBlockState, blockStateID, blockPos, loopBlockPos, startX, startZ);
                    if (tint2 != -1) {
                        surfaceColor = ColorUtils.colorMultiplier(surfaceColor, tint2);
                    }
                } else {
                    surfaceColor = this.colorManager.getBlockColorWithDefaultTint(blockPos, blockStateID);
                }
                surfaceColor = this.applyHeight(mapData, surfaceColor, underground, multi, imageX, imageY, surfaceHeight, solid, 1);
                int light = mapData.getLight(imageX, imageY);
                if (solid) {
                    surfaceColor = 0;
                } else if (this.mapOptions.lightmap) {
                    int lightValue2 = this.getLight(light);
                    surfaceColor = ColorUtils.colorMultiplier(surfaceColor, lightValue2);
                }
                if (this.mapOptions.waterTransparency && !solid && (seafloorHeight = mapData.getOceanFloorHeight(imageX, imageY)) > 0) {
                    blockPos.setXYZ(mcX, seafloorHeight - 1, mcZ);
                    class_2680 seafloorBlockState = mapData.getOceanFloorBlockstate(imageX, imageY);
                    if (seafloorBlockState != null && seafloorBlockState != BlockRepository.air.method_9564()) {
                        blockStateID = BlockRepository.getStateId(seafloorBlockState);
                        if (this.mapOptions.biomes) {
                            seafloorColor = this.colorManager.getBlockColor(blockPos, blockStateID, biomeID);
                            tint = this.colorManager.getBiomeTint(mapData, (class_1937)world, seafloorBlockState, blockStateID, blockPos, loopBlockPos, startX, startZ);
                            if (tint != -1) {
                                seafloorColor = ColorUtils.colorMultiplier(seafloorColor, tint);
                            }
                        } else {
                            seafloorColor = this.colorManager.getBlockColorWithDefaultTint(blockPos, blockStateID);
                        }
                        seafloorColor = this.applyHeight(mapData, seafloorColor, underground, multi, imageX, imageY, seafloorHeight, solid, 0);
                        int seafloorLight = mapData.getOceanFloorLight(imageX, imageY);
                        if (this.mapOptions.lightmap) {
                            lightValue = this.getLight(seafloorLight);
                            seafloorColor = ColorUtils.colorMultiplier(seafloorColor, lightValue);
                        }
                    }
                }
                if (this.mapOptions.blockTransparency && !solid) {
                    transparentHeight = mapData.getTransparentHeight(imageX, imageY);
                    if (transparentHeight > 0) {
                        blockPos.setXYZ(mcX, transparentHeight - 1, mcZ);
                        class_2680 transparentBlockState = mapData.getTransparentBlockstate(imageX, imageY);
                        if (transparentBlockState != null && transparentBlockState != BlockRepository.air.method_9564()) {
                            blockStateID = BlockRepository.getStateId(transparentBlockState);
                            if (this.mapOptions.biomes) {
                                transparentColor = this.colorManager.getBlockColor(blockPos, blockStateID, biomeID);
                                tint = this.colorManager.getBiomeTint(mapData, (class_1937)world, transparentBlockState, blockStateID, blockPos, loopBlockPos, startX, startZ);
                                if (tint != -1) {
                                    transparentColor = ColorUtils.colorMultiplier(transparentColor, tint);
                                }
                            } else {
                                transparentColor = this.colorManager.getBlockColorWithDefaultTint(blockPos, blockStateID);
                            }
                            transparentColor = this.applyHeight(mapData, transparentColor, underground, multi, imageX, imageY, transparentHeight, solid, 3);
                            int transparentLight = mapData.getTransparentLight(imageX, imageY);
                            if (this.mapOptions.lightmap) {
                                lightValue = this.getLight(transparentLight);
                                transparentColor = ColorUtils.colorMultiplier(transparentColor, lightValue);
                            }
                        }
                    }
                    if ((foliageHeight = mapData.getFoliageHeight(imageX, imageY)) > 0) {
                        blockPos.setXYZ(mcX, foliageHeight - 1, mcZ);
                        class_2680 foliageBlockState = mapData.getFoliageBlockstate(imageX, imageY);
                        if (foliageBlockState != null && foliageBlockState != BlockRepository.air.method_9564()) {
                            blockStateID = BlockRepository.getStateId(foliageBlockState);
                            if (this.mapOptions.biomes) {
                                foliageColor = this.colorManager.getBlockColor(blockPos, blockStateID, biomeID);
                                tint = this.colorManager.getBiomeTint(mapData, (class_1937)world, foliageBlockState, blockStateID, blockPos, loopBlockPos, startX, startZ);
                                if (tint != -1) {
                                    foliageColor = ColorUtils.colorMultiplier(foliageColor, tint);
                                }
                            } else {
                                foliageColor = this.colorManager.getBlockColorWithDefaultTint(blockPos, blockStateID);
                            }
                            foliageColor = this.applyHeight(mapData, foliageColor, underground, multi, imageX, imageY, foliageHeight, solid, 2);
                            int foliageLight = mapData.getFoliageLight(imageX, imageY);
                            if (this.mapOptions.lightmap) {
                                lightValue = this.getLight(foliageLight);
                                foliageColor = ColorUtils.colorMultiplier(foliageColor, lightValue);
                            }
                        }
                    }
                }
                if (this.mapOptions.waterTransparency && seafloorHeight > 0) {
                    color24 = seafloorColor;
                    if (foliageColor != 0 && foliageHeight <= surfaceHeight) {
                        color24 = ColorUtils.colorAdder(foliageColor, seafloorColor);
                    }
                    if (transparentColor != 0 && transparentHeight <= surfaceHeight) {
                        color24 = ColorUtils.colorAdder(transparentColor, color24);
                    }
                    color24 = ColorUtils.colorAdder(surfaceColor, color24);
                } else {
                    color24 = surfaceColor;
                }
                if (foliageColor != 0 && foliageHeight > surfaceHeight) {
                    color24 = ColorUtils.colorAdder(foliageColor, color24);
                }
                if (transparentColor != 0 && transparentHeight > surfaceHeight) {
                    color24 = ColorUtils.colorAdder(transparentColor, color24);
                }
                if (this.mapOptions.biomeOverlay == 2) {
                    int bc = 0;
                    if (biomeID >= 0) {
                        bc = BiomeRepository.getBiomeColor(biomeID);
                    }
                    bc = 0x7F000000 | bc;
                    color24 = ColorUtils.colorAdder(bc, color24);
                }
            }
            return MapUtils.doSlimeAndGrid(color24, mcX, mcZ);
        }
        return 0;
    }

    private int applyHeight(AbstractMapData mapData, int color24, boolean underground, int multi, int imageX, int imageY, int height, boolean solid, int layer) {
        if (color24 != this.colorManager.getAirColor() && color24 != 0) {
            int heightComp = -1;
            if ((this.mapOptions.heightmap || this.mapOptions.slopemap) && !solid) {
                double sc = 0.0;
                boolean invert = false;
                if (!this.mapOptions.slopemap) {
                    int diff = height - 80;
                    sc = Math.log10((double)Math.abs(diff) / 8.0 + 1.0) / 1.8;
                    if (diff < 0) {
                        sc = 0.0 - sc;
                    }
                } else {
                    int diff;
                    if (imageX > 0 && imageY < 32 * multi - 1) {
                        if (layer == 0) {
                            heightComp = mapData.getOceanFloorHeight(imageX - 1, imageY + 1);
                        }
                        if (layer == 1) {
                            heightComp = mapData.getHeight(imageX - 1, imageY + 1);
                        }
                        if (layer == 2) {
                            heightComp = height;
                        }
                        if (layer == 3 && (heightComp = mapData.getTransparentHeight(imageX - 1, imageY + 1)) == -1 && (transparentBlockState = mapData.getTransparentBlockstate(imageX, imageY)) != null && transparentBlockState != BlockRepository.air.method_9564() && ((block = transparentBlockState.method_26204()) instanceof class_2368 || block instanceof class_2506)) {
                            heightComp = mapData.getHeight(imageX - 1, imageY + 1);
                        }
                    } else if (imageX < 32 * multi - 1 && imageY > 0) {
                        if (layer == 0) {
                            heightComp = mapData.getOceanFloorHeight(imageX + 1, imageY - 1);
                        }
                        if (layer == 1) {
                            heightComp = mapData.getHeight(imageX + 1, imageY - 1);
                        }
                        if (layer == 2) {
                            heightComp = height;
                        }
                        if (layer == 3 && (heightComp = mapData.getTransparentHeight(imageX + 1, imageY - 1)) == -1 && (transparentBlockState = mapData.getTransparentBlockstate(imageX, imageY)) != null && transparentBlockState != BlockRepository.air.method_9564() && ((block = transparentBlockState.method_26204()) instanceof class_2368 || block instanceof class_2506)) {
                            heightComp = mapData.getHeight(imageX + 1, imageY - 1);
                        }
                        invert = true;
                    } else {
                        heightComp = height;
                    }
                    if (heightComp == -1) {
                        heightComp = height;
                    }
                    if ((diff = !invert ? heightComp - height : height - heightComp) != 0) {
                        sc = diff > 0 ? 1.0 : -1.0;
                        sc /= 8.0;
                    }
                    if (this.mapOptions.heightmap) {
                        diff = height - 80;
                        double heightsc = Math.log10((double)Math.abs(diff) / 8.0 + 1.0) / 3.0;
                        sc = diff > 0 ? sc + heightsc : sc - heightsc;
                    }
                }
                int alpha = color24 >> 24 & 0xFF;
                int r = color24 >> 16 & 0xFF;
                int g = color24 >> 8 & 0xFF;
                int b = color24 & 0xFF;
                if (sc > 0.0) {
                    r += (int)(sc * (double)(255 - r));
                    g += (int)(sc * (double)(255 - g));
                    b += (int)(sc * (double)(255 - b));
                } else if (sc < 0.0) {
                    sc = Math.abs(sc);
                    r -= (int)(sc * (double)r);
                    g -= (int)(sc * (double)g);
                    b -= (int)(sc * (double)b);
                }
                color24 = alpha * 0x1000000 + r * 65536 + g * 256 + b;
            }
        }
        return color24;
    }

    private int getLight(int light) {
        return this.lightmapColors[light];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedRegion[] getRegions(int left, int right, int top, int bottom) {
        if (left == this.lastLeft && right == this.lastRight && top == this.lastTop && bottom == this.lastBottom) {
            return this.lastRegionsArray;
        }
        ThreadManager.emptyQueue();
        CachedRegion[] visibleCachedRegionsArray = new CachedRegion[(right - left + 1) * (bottom - top + 1)];
        String worldName = VoxelConstants.getVoxelMapInstance().getWaypointManager().getCurrentWorldName();
        String subWorldName = VoxelConstants.getVoxelMapInstance().getWaypointManager().getCurrentSubworldDescriptor(false);
        ArrayList<RegionCoordinates> regionsToDisplay = new ArrayList<RegionCoordinates>();
        for (int t = left; t <= right; ++t) {
            for (int s = top; s <= bottom; ++s) {
                RegionCoordinates regionCoordinates = new RegionCoordinates(t, s);
                regionsToDisplay.add(regionCoordinates);
            }
        }
        regionsToDisplay.sort(this.distanceSorter);
        for (RegionCoordinates regionCoordinates : regionsToDisplay) {
            CachedRegion cachedRegion;
            int x = regionCoordinates.x;
            int z = regionCoordinates.z;
            String key = x + "," + z;
            ConcurrentHashMap<String, CachedRegion> concurrentHashMap = this.cachedRegions;
            synchronized (concurrentHashMap) {
                cachedRegion = this.cachedRegions.get(key);
                if (cachedRegion == null) {
                    cachedRegion = new CachedRegion(this, key, this.world, worldName, subWorldName, x, z);
                    this.cachedRegions.put(key, cachedRegion);
                    List<CachedRegion> list = this.cachedRegionsPool;
                    synchronized (list) {
                        this.cachedRegionsPool.add(cachedRegion);
                    }
                }
            }
            cachedRegion.refresh(true);
            visibleCachedRegionsArray[(z - top) * (right - left + 1) + (x - left)] = cachedRegion;
        }
        this.prunePool();
        CachedRegion[] cachedRegionArray = this.lastRegionsArray;
        synchronized (this.lastRegionsArray) {
            this.lastLeft = left;
            this.lastRight = right;
            this.lastTop = top;
            this.lastBottom = bottom;
            this.lastRegionsArray = visibleCachedRegionsArray;
            // ** MonitorExit[var9_10] (shouldn't be in output)
            return visibleCachedRegionsArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prunePool() {
        List<CachedRegion> list = this.cachedRegionsPool;
        synchronized (list) {
            Iterator<CachedRegion> iterator = this.cachedRegionsPool.iterator();
            while (iterator.hasNext()) {
                CachedRegion region = iterator.next();
                if (!region.isLoaded() || !region.isEmpty()) continue;
                this.cachedRegions.put(region.getKey(), CachedRegion.emptyRegion);
                region.cleanup();
                iterator.remove();
            }
            if (this.cachedRegionsPool.size() > this.options.cacheSize) {
                this.cachedRegionsPool.sort(this.ageThenDistanceSorter);
                List<CachedRegion> toRemove = this.cachedRegionsPool.subList(this.options.cacheSize, this.cachedRegionsPool.size());
                for (CachedRegion cachedRegion : toRemove) {
                    this.cachedRegions.remove(cachedRegion.getKey());
                    cachedRegion.cleanup();
                }
                toRemove.clear();
            }
            this.compress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compress() {
        List<CachedRegion> list = this.cachedRegionsPool;
        synchronized (list) {
            for (CachedRegion cachedRegion : this.cachedRegionsPool) {
                if (System.currentTimeMillis() - cachedRegion.getMostRecentChange() <= 5000L) continue;
                cachedRegion.compress();
            }
        }
    }

    @Override
    public void handleChangeInWorld(int chunkX, int chunkZ) {
        class_2818 chunk;
        if (this.world != null && (chunk = this.world.method_8497(chunkX, chunkZ)) != null && !chunk.method_12223() && this.isChunkReady(this.world, chunk)) {
            this.processChunk(chunk);
        }
    }

    @Override
    public void processChunk(class_2818 chunk) {
        this.chunkUpdateQueue.add(new ChunkWithAge(chunk, VoxelConstants.getElapsedTicks()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void doProcessChunk(class_2818 chunk) {
        this.queuedChangedChunks = true;
        try {
            if (this.world == null) {
                return;
            }
            if (chunk == null) return;
            if (chunk.method_12223()) {
                return;
            }
            int chunkX = chunk.method_12004().field_9181;
            int chunkZ = chunk.method_12004().field_9180;
            int regionX = (int)Math.floor((double)chunkX / 16.0);
            int regionZ = (int)Math.floor((double)chunkZ / 16.0);
            String key = regionX + "," + regionZ;
            ConcurrentHashMap<String, CachedRegion> concurrentHashMap = this.cachedRegions;
            // MONITORENTER : concurrentHashMap
            CachedRegion cachedRegion = this.cachedRegions.get(key);
            if (cachedRegion == null || cachedRegion == CachedRegion.emptyRegion) {
                String worldName = VoxelConstants.getVoxelMapInstance().getWaypointManager().getCurrentWorldName();
                String subWorldName = VoxelConstants.getVoxelMapInstance().getWaypointManager().getCurrentSubworldDescriptor(false);
                cachedRegion = new CachedRegion(this, key, this.world, worldName, subWorldName, regionX, regionZ);
                this.cachedRegions.put(key, cachedRegion);
                CachedRegion[] cachedRegionArray = this.cachedRegionsPool;
                // MONITORENTER : this.cachedRegionsPool
                this.cachedRegionsPool.add(cachedRegion);
                // MONITOREXIT : cachedRegionArray
                cachedRegionArray = this.lastRegionsArray;
                // MONITORENTER : this.lastRegionsArray
                if (regionX >= this.lastLeft && regionX <= this.lastRight && regionZ >= this.lastTop && regionZ <= this.lastBottom) {
                    this.lastRegionsArray[(regionZ - this.lastTop) * (this.lastRight - this.lastLeft + 1) + (regionX - this.lastLeft)] = cachedRegion;
                }
                // MONITOREXIT : cachedRegionArray
            }
            // MONITOREXIT : concurrentHashMap
            if (VoxelConstants.getMinecraft().field_1755 != null && VoxelConstants.getMinecraft().field_1755 instanceof GuiPersistentMap) {
                cachedRegion.registerChangeAt(chunkX, chunkZ);
                cachedRegion.refresh(false);
                return;
            }
            cachedRegion.handleChangedChunk(chunk);
            return;
        }
        catch (Exception var19) {
            VoxelConstants.getLogger().error(var19.getMessage(), (Throwable)var19);
        }
    }

    private boolean isChunkReady(class_638 world, class_2818 chunk) {
        return this.chunkCache.isChunkSurroundedByLoaded(chunk.method_12004().field_9181, chunk.method_12004().field_9180);
    }

    public boolean isRegionLoaded(int blockX, int blockZ) {
        int z;
        int x = (int)Math.floor((float)blockX / 256.0f);
        CachedRegion cachedRegion = this.cachedRegions.get(x + "," + (z = (int)Math.floor((float)blockZ / 256.0f)));
        return cachedRegion != null && cachedRegion.isLoaded();
    }

    public boolean isGroundAt(int blockX, int blockZ) {
        int z;
        int x = (int)Math.floor((float)blockX / 256.0f);
        CachedRegion cachedRegion = this.cachedRegions.get(x + "," + (z = (int)Math.floor((float)blockZ / 256.0f)));
        return cachedRegion != null && cachedRegion.isGroundAt(blockX, blockZ);
    }

    public int getHeightAt(int blockX, int blockZ) {
        int z;
        int x = (int)Math.floor((float)blockX / 256.0f);
        CachedRegion cachedRegion = this.cachedRegions.get(x + "," + (z = (int)Math.floor((float)blockZ / 256.0f)));
        return cachedRegion == null ? 64 : cachedRegion.getHeightAt(blockX, blockZ);
    }

    private record ChunkWithAge(class_2818 chunk, int tick) {
    }

    private record RegionCoordinates(int x, int z) {
    }
}

