/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.config.gui;

import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.config.gui.ConfigScreen;
import dlovin.inventoryhud.config.widgets.CheckBox;
import dlovin.inventoryhud.config.widgets.CustomButton;
import dlovin.inventoryhud.config.widgets.NumericTextField;
import dlovin.inventoryhud.config.widgets.TextWidget;
import dlovin.inventoryhud.references.Translation;
import dlovin.inventoryhud.utils.WidgetAligns;
import net.minecraft.class_124;
import net.minecraft.class_2960;
import net.minecraft.class_437;

public class ArmorConfigScreen
extends ConfigScreen {
    private CustomButton ToggleBtn;
    private CustomButton ViewBtn;
    private CustomButton BarsBtn;
    private CustomButton MoveAllBtn;
    private CustomButton ShowEmpty;
    private CustomButton ShowCountBtn;
    private CustomButton ScaleBtn;
    private NumericTextField AboveField;

    public ArmorConfigScreen(class_437 prev, boolean inGame) {
        super(prev, 1, inGame);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        String toggle = InventoryHUD.getConfig().getArm() ? class_124.field_1077 + "ON" : class_124.field_1079 + "OFF";
        this.ToggleBtn = new CustomButton(this.field_22789 / 2 + 20, 0, 40, 20, toggle, null, false);
        this.OptionList.addWidget(this.ToggleBtn, 0);
        this.ToggleBtn.addListener(this::ToggleSwitch);
        this.AboveField = new NumericTextField(this.field_22793, this.field_22789 / 2 + 20, 0, 40, 20, 0, 100, InventoryHUD.getConfig().getArmAbove(), tf -> this.AboveChanged());
        this.OptionList.addWidget(this.AboveField, 1);
        this.OptionList.addWidget(new CheckBox(this.field_22789 / 2 + 20, 0, 20, 20, this::TypeArmorChanged, InventoryHUD.getConfig().isShowArmor(), new class_2960("inventoryhud", "textures/gui/cb_arm.png")), 2);
        this.OptionList.addWidget(new CheckBox(this.field_22789 / 2 + 42, 0, 20, 20, this::TypeMainHandChanged, InventoryHUD.getConfig().isShowMain(), new class_2960("inventoryhud", "textures/gui/cb_mh.png")), 2);
        this.OptionList.addWidget(new CheckBox(this.field_22789 / 2 + 64, 0, 20, 20, this::TypeOffHandChanged, InventoryHUD.getConfig().isShowOff(), new class_2960("inventoryhud", "textures/gui/cb_oh.png")), 2);
        this.OptionList.addWidget(new CheckBox(this.field_22789 / 2 + 86, 0, 20, 20, this::TypeArrowChanged, InventoryHUD.getConfig().isShowArrows(), new class_2960("inventoryhud", "textures/gui/cb_ar.png")), 2);
        this.OptionList.addWidget(new CheckBox(this.field_22789 / 2 + 108, 0, 20, 20, this::TypeInvChanged, InventoryHUD.getConfig().isShowInv(), new class_2960("inventoryhud", "textures/gui/cb_inv.png")), 2);
        this.ViewBtn = new CustomButton(this.field_22789 / 2 + 20, 0, 75, 20, InventoryHUD.getConfig().getArmView().name(), null, false);
        this.OptionList.addWidget(this.ViewBtn, 3);
        this.ViewBtn.addListener(this::ViewSwitch);
        this.BarsBtn = new CustomButton(this.field_22789 / 2 + 20, 0, 40, 20, "" + InventoryHUD.getConfig().getArmBars(), null, false);
        this.OptionList.addWidget(this.BarsBtn, 4);
        this.BarsBtn.addListener(this::BarsSwitch);
        this.MoveAllBtn = new CustomButton(this.field_22789 / 2 + 20, 0, 40, 20, "" + InventoryHUD.getConfig().getMoveAll(), null, false);
        this.OptionList.addWidget(this.MoveAllBtn, 5);
        this.MoveAllBtn.addListener(this::MoveSwitch);
        this.ShowEmpty = new CustomButton(this.field_22789 / 2 + 20, 0, 40, 20, "" + InventoryHUD.getConfig().isShowEmpty(), null, false);
        this.OptionList.addWidget(this.ShowEmpty, 6);
        this.ShowEmpty.addListener(this::EmptySwitch);
        this.ShowCountBtn = new CustomButton(this.field_22789 / 2 + 20, 0, 40, 20, "" + InventoryHUD.getConfig().isShowCount(), null, false);
        this.OptionList.addWidget(this.ShowCountBtn, 7);
        this.ShowCountBtn.addListener(this::ShowCountSwitch);
        float sc = (float)InventoryHUD.getConfig().getArmScale() / 100.0f;
        String t = sc + "x";
        this.ScaleBtn = new CustomButton(this.field_22789 / 2 + 20, 0, 40, 20, t, null, false);
        this.OptionList.addWidget(this.ScaleBtn, 8);
        this.ScaleBtn.addListener(this::ScaleSwitch);
        this.OptionList.addWidget(new TextWidget(this.field_22789 / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_SCALE.getString(), this.field_22793, (w, m, x, y) -> this.method_25424(m, Translation.ARM_SCALE_TT, x, y)), 8);
        this.OptionList.addWidget(new TextWidget(this.field_22789 / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_COUNT.getString(), this.field_22793, (w, m, x, y) -> this.method_25424(m, Translation.ARM_COUNT_TT, x, y)), 7);
        this.OptionList.addWidget(new TextWidget(this.field_22789 / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_EMPTY.getString(), this.field_22793, (w, m, x, y) -> this.method_25424(m, Translation.ARM_EMPTY_TT, x, y)), 6);
        this.OptionList.addWidget(new TextWidget(this.field_22789 / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_MOVE.getString(), this.field_22793, (w, m, x, y) -> this.method_30901(m, Translation.ARM_MOVE_TT, x, y)), 5);
        this.OptionList.addWidget(new TextWidget(this.field_22789 / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_BARS.getString(), this.field_22793, (w, m, x, y) -> this.method_25424(m, Translation.ARM_BARS_TT, x, y)), 4);
        this.OptionList.addWidget(new TextWidget(this.field_22789 / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_VIEW.getString(), this.field_22793, (w, m, x, y) -> this.method_30901(m, Translation.ARM_VIEW_TT, x, y)), 3);
        this.OptionList.addWidget(new TextWidget(this.field_22789 / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_TYPE.getString(), this.field_22793, (w, m, x, y) -> this.method_25424(m, Translation.ARM_TYPE_TT, x, y)), 2);
        this.OptionList.addWidget(new TextWidget(this.field_22789 / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_HIDE.getString(), this.field_22793, (w, m, x, y) -> this.method_25424(m, Translation.ARM_HIDE_TT, x, y)), 1);
        this.OptionList.addWidget(new TextWidget(this.field_22789 / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_TOGGLE.getString(), this.field_22793, (w, m, x, y) -> this.method_25424(m, Translation.ARM_TOGGLE_TT, x, y)), 0);
        this.AboveField.setMaxStringLength(5);
    }

    private void ScaleSwitch() {
        int scale = (InventoryHUD.getInstance().getInvhudGUI().armorRenderer.armScale + 25) % 175;
        if (scale == 0) {
            scale = 50;
        }
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.armScale = scale;
        InventoryHUD.getInstance().getInvhudGUI().changeArmorOffset();
        InventoryHUD.getConfig().setArmScale(scale);
        float sc = (float)scale / 100.0f;
        String t = sc + "x";
        this.ScaleBtn.setMessage(t);
        if (InventoryHUD.isTrinketMod) {
            InventoryHUD.getInstance().getInvhudGUI().trinketRenderer.armScale = scale;
        }
    }

    private void ShowCountSwitch() {
        boolean bd;
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.showCount = bd = !InventoryHUD.getConfig().isShowCount();
        InventoryHUD.getConfig().setShowCount(bd);
        this.ShowCountBtn.setMessage(Boolean.toString(bd));
        if (InventoryHUD.isTrinketMod) {
            InventoryHUD.getInstance().getInvhudGUI().trinketRenderer.showCount = bd;
        }
    }

    private void TypeArmorChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.showArmor = cb.checked;
        InventoryHUD.getConfig().setShowArmor(cb.checked);
    }

    private void TypeMainHandChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.showMain = cb.checked;
        InventoryHUD.getConfig().setShowMain(cb.checked);
    }

    private void TypeOffHandChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.showOff = cb.checked;
        InventoryHUD.getConfig().setShowOff(cb.checked);
    }

    private void TypeArrowChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.showArrows = cb.checked;
        InventoryHUD.getConfig().setShowArrows(cb.checked);
    }

    private void TypeInvChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.showInv = cb.checked;
        InventoryHUD.getConfig().setShowInv(cb.checked);
    }

    private void AboveChanged() {
        int a;
        try {
            a = Integer.parseInt(this.AboveField.getText());
        }
        catch (NumberFormatException ex) {
            a = 100;
        }
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.armAbove = a;
        InventoryHUD.getConfig().setArmAbove(a);
        if (InventoryHUD.isTrinketMod) {
            InventoryHUD.getInstance().getInvhudGUI().trinketRenderer.armAbove = a;
        }
    }

    private void MoveSwitch() {
        boolean bd = !InventoryHUD.getConfig().getMoveAll();
        InventoryHUD.getInstance().getInvhudGUI().changeMoveAll(bd);
        InventoryHUD.getConfig().setMoveAll(bd);
        this.MoveAllBtn.setMessage(Boolean.toString(bd));
    }

    private void EmptySwitch() {
        boolean bd;
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.showEmpty = bd = !InventoryHUD.getConfig().isShowEmpty();
        InventoryHUD.getConfig().setShowEmpty(bd);
        this.ShowEmpty.setMessage(Boolean.toString(bd));
        if (InventoryHUD.isTrinketMod) {
            InventoryHUD.getInstance().getInvhudGUI().trinketRenderer.showEmpty = bd;
        }
    }

    private void ViewSwitch() {
        InvConfig.ArmorView at;
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.armView = at = (switch (InventoryHUD.getConfig().getArmView()) {
            default -> throw new IncompatibleClassChangeError();
            case InvConfig.ArmorView.PERCENTAGE -> InvConfig.ArmorView.DAMAGE;
            case InvConfig.ArmorView.DAMAGE -> InvConfig.ArmorView.DAMAGE_LEFT;
            case InvConfig.ArmorView.DAMAGE_LEFT -> InvConfig.ArmorView.OFF;
            case InvConfig.ArmorView.OFF -> InvConfig.ArmorView.PERCENTAGE;
        });
        InventoryHUD.getConfig().setArmView(at);
        this.ViewBtn.setMessage(at.name());
        if (InventoryHUD.isTrinketMod) {
            InventoryHUD.getInstance().getInvhudGUI().trinketRenderer.armView = at;
        }
    }

    private void ToggleSwitch() {
        boolean armor;
        InventoryHUD.ArmHUD = armor = !InventoryHUD.getConfig().getArm();
        InventoryHUD.getConfig().setArm(armor);
        String armString = armor ? class_124.field_1077 + "ON" : class_124.field_1079 + "OFF";
        this.ToggleBtn.setMessage(armString);
    }

    private void BarsSwitch() {
        boolean bars;
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.armBars = bars = !InventoryHUD.getConfig().getArmBars();
        InventoryHUD.getConfig().setArmBars(bars);
        this.BarsBtn.setMessage(Boolean.toString(bars));
        if (InventoryHUD.isTrinketMod) {
            InventoryHUD.getInstance().getInvhudGUI().trinketRenderer.armBars = bars;
        }
    }
}

