/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.config.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.config.gui.PotionConfigScreen;
import dlovin.inventoryhud.config.gui.ScreenWithOptionList;
import dlovin.inventoryhud.config.widgets.CustomButton;
import dlovin.inventoryhud.config.widgets.CustomOptionList;
import dlovin.inventoryhud.config.widgets.IconWidget;
import dlovin.inventoryhud.config.widgets.TextField;
import dlovin.inventoryhud.references.Translation;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import org.jetbrains.annotations.NotNull;

public class EffectsBlacklistScreen
extends ScreenWithOptionList {
    private boolean inGame;
    private CustomButton saveBtn;
    private class_437 prevScreen;

    public EffectsBlacklistScreen(class_437 prevScreen, boolean inGame) {
        super(Translation.BLACKLIST_TITLE);
        this.inGame = inGame;
        this.prevScreen = prevScreen;
    }

    protected void method_25426() {
        this.OptionList = new CustomOptionList(this.field_22787, this, 32);
        this.addControlLine();
        List<String> effectList = InventoryHUD.getConfig().getEffectsBlacklist();
        for (int i = 0; i < effectList.size(); ++i) {
            this.addLine(i, effectList.get(i));
        }
        this.method_37063((class_364)this.OptionList);
    }

    private void addLine(int i, String effect) {
        IconWidget effectIcon = new IconWidget(this.field_22789 / 2 + 105, 0, 20, 20, effect);
        this.OptionList.insertWidget(effectIcon, i);
        this.OptionList.addWidget(new TextField(this.field_22793, this.field_22789 / 2 - 100, 0, 200, 20, effect, w -> {
            effectIcon.setEffectAtlasSprite(w.getText());
            this.saveBtn.setMessage(class_124.field_1061 + Translation.SAVE.getString());
        }, "[a-z0-9._-]*[/:]?[a-z0-9._-]*"), i);
        int deleteBtnSize = this.field_22793.method_1727(Translation.DELETE.getString()) + 8;
        CustomButton deleteBtn = new CustomButton(this.field_22789 / 2 - deleteBtnSize - 105, 0, deleteBtnSize, 20, Translation.DELETE.getString(), null, false);
        this.OptionList.addWidget(deleteBtn, i);
        deleteBtn.addListener(() -> {
            this.OptionList.removeRowWith(deleteBtn);
            this.saveBtn.setMessage(class_124.field_1061 + Translation.SAVE.getString());
        });
    }

    private void addControlLine() {
        int saveBtnSize = this.field_22793.method_1727(Translation.SAVE.getString()) + 8;
        int addBtnSize = this.field_22793.method_1727(Translation.ADD.getString()) + 8;
        this.saveBtn = new CustomButton(this.field_22789 / 2 - saveBtnSize - 5, 0, saveBtnSize, 20, class_124.field_1060 + Translation.SAVE.getString(), null, false);
        this.OptionList.addWidget(this.saveBtn, 0);
        this.saveBtn.addListener(this::saveEffects);
        CustomButton nextButton = new CustomButton(this.field_22789 / 2 + 5, 0, addBtnSize, 20, Translation.ADD.getString(), null, false);
        this.OptionList.addWidget(nextButton, 0);
        nextButton.addListener(this::addEffect);
    }

    private void saveEffects() {
        List<String> effects = this.OptionList.getWidgets().stream().filter(w -> w instanceof TextField).map(w -> ((TextField)((Object)w)).getText()).toList();
        InventoryHUD.getConfig().setEffectsBlacklist(effects);
        InventoryHUD.getInstance().getInvhudGUI().resetBlackList();
        this.saveBtn.setMessage(class_124.field_1060 + Translation.SAVE.getString());
    }

    private void addEffect() {
        this.addLine(this.OptionList.rowsCount() - 1, "");
        this.saveBtn.setMessage(class_124.field_1061 + Translation.SAVE.getString());
    }

    public void method_25394(@NotNull class_4587 stack, int mouseX, int mouseY, float partialTick) {
        this.method_25420(stack);
        this.OptionList.method_25394(stack, mouseX, mouseY, partialTick);
        this.renderTitle(stack);
        this.OptionList.renderTooltips(stack, mouseX, mouseY);
    }

    public void renderTitle(@NotNull class_4587 stack) {
        stack.method_22903();
        stack.method_46416((float)(this.field_22789 / 2), 10.0f, 0.0f);
        stack.method_22903();
        RenderSystem.enableBlend();
        stack.method_22905(2.0f, 2.0f, 2.0f);
        EffectsBlacklistScreen.method_35719((class_4587)stack, (class_327)this.field_22793, (class_5481)this.field_22785.method_30937(), (int)0, (int)0, (int)-1);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        stack.method_22909();
        stack.method_22909();
    }

    public void method_25419() {
        this.field_22787.method_1507((class_437)new PotionConfigScreen(this.prevScreen, this.inGame));
    }
}

