/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.config.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.config.widgets.ButtonWidget;
import dlovin.inventoryhud.utils.Color4F;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;

public class ConfigWidget
extends ButtonWidget {
    private final class_310 mc;
    protected class_2960 resourceLocation;
    protected class_2960 icon;
    protected float texOffX;
    protected float texOffY;
    protected float scale;
    protected Color4F color;
    protected boolean isShow;
    protected boolean isDisableable;
    protected boolean snapable;
    private final List<ConfigWidgetListener> listeners = new ArrayList<ConfigWidgetListener>();
    private final List<ConfigWidgetPosListener> posListeners = new ArrayList<ConfigWidgetPosListener>();
    private double d_x;
    private double d_y;

    public ConfigWidget(int xIn, int yIn, int widthIn, int heightIn, float scaleIn, boolean snapable, String msg, boolean isShow, boolean isDisableable) {
        this(xIn, yIn, widthIn, heightIn, scaleIn, msg, isShow, isDisableable);
        this.snapable = snapable;
    }

    public ConfigWidget(int xIn, int yIn, int widthIn, int heightIn, float scaleIn, String msg, boolean isShow) {
        this(xIn, yIn, widthIn, heightIn, scaleIn, msg, isShow, true);
    }

    public ConfigWidget(int xIn, int yIn, int widthIn, int heightIn, float scaleIn, String msg, boolean isShow, boolean isDisableable) {
        super(xIn, yIn, (int)((float)widthIn * scaleIn), (int)((float)heightIn * scaleIn), msg);
        this.d_x = xIn;
        this.d_y = yIn;
        this.isShow = isShow;
        this.scale = scaleIn;
        this.mc = class_310.method_1551();
        this.isDisableable = isDisableable;
        this.snapable = true;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void addListener(ConfigWidgetListener act) {
        this.listeners.add(act);
    }

    public void addPosListener(ConfigWidgetPosListener act) {
        this.posListeners.add(act);
    }

    public boolean getShow() {
        return this.isShow;
    }

    public void initTextureValues(int xTexStartIn, int yTexStartIn, Color4F color, class_2960 resourceLocationIn) {
        this.initTextureValues(xTexStartIn, yTexStartIn, color, resourceLocationIn, null);
    }

    public void initTextureValues(int xTexStartIn, int yTexStartIn, Color4F color, class_2960 resourceLocationIn, class_2960 iconIn) {
        this.resourceLocation = resourceLocationIn;
        this.texOffX = (float)xTexStartIn * this.scale;
        this.texOffY = (float)yTexStartIn * this.scale;
        this.color = color;
        this.icon = iconIn;
    }

    private void renderBg(class_4587 mat) {
        ConfigWidget.method_25293((class_4587)mat, (int)this.x, (int)this.y, (int)3, (int)3, (float)0.0f, (float)0.0f, (int)3, (int)3, (int)256, (int)256);
        ConfigWidget.method_25293((class_4587)mat, (int)(this.x + this.width - 3), (int)this.y, (int)3, (int)3, (float)13.0f, (float)0.0f, (int)3, (int)3, (int)256, (int)256);
        ConfigWidget.method_25293((class_4587)mat, (int)this.x, (int)(this.y + this.height - 3), (int)3, (int)3, (float)0.0f, (float)13.0f, (int)3, (int)3, (int)256, (int)256);
        ConfigWidget.method_25293((class_4587)mat, (int)(this.x + this.width - 3), (int)(this.y + this.height - 3), (int)3, (int)3, (float)13.0f, (float)13.0f, (int)3, (int)3, (int)256, (int)256);
        ConfigWidget.method_25293((class_4587)mat, (int)(this.x + 3), (int)this.y, (int)(this.width - 6), (int)3, (float)3.0f, (float)0.0f, (int)10, (int)3, (int)256, (int)256);
        ConfigWidget.method_25293((class_4587)mat, (int)(this.x + this.width - 3), (int)(this.y + 3), (int)3, (int)(this.height - 6), (float)13.0f, (float)3.0f, (int)3, (int)10, (int)256, (int)256);
        ConfigWidget.method_25293((class_4587)mat, (int)(this.x + 3), (int)(this.y + this.height - 3), (int)(this.width - 6), (int)3, (float)3.0f, (float)13.0f, (int)10, (int)3, (int)256, (int)256);
        ConfigWidget.method_25293((class_4587)mat, (int)this.x, (int)(this.y + 3), (int)3, (int)(this.height - 6), (float)0.0f, (float)3.0f, (int)3, (int)10, (int)256, (int)256);
        ConfigWidget.method_25293((class_4587)mat, (int)(this.x + 3), (int)(this.y + 3), (int)(this.width - 6), (int)(this.height - 6), (float)3.0f, (float)3.0f, (int)10, (int)10, (int)256, (int)256);
    }

    @Override
    public void method_25394(class_4587 mat, int mx, int my, float pt) {
        super.method_25394(mat, mx, my, pt);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.resourceLocation);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)this.color.r, (float)this.color.g, (float)this.color.b, (float)this.color.a);
        this.renderBg(mat);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.icon != null) {
            RenderSystem.setShaderTexture((int)0, (class_2960)this.icon);
            int size = this.width - 2;
            ConfigWidget.method_25290((class_4587)mat, (int)(this.x + this.width / 2 - size / 2), (int)(this.y + this.height / 2 - size / 2), (float)size, (float)size, (int)size, (int)size, (int)size, (int)size);
        }
        if (this.isDisableable) {
            if (this.isShow) {
                ConfigWidget.method_25302((class_4587)mat, (int)(this.x + this.width - 12), (int)(this.y + 2), (int)162, (int)0, (int)10, (int)10);
            } else {
                ConfigWidget.method_25302((class_4587)mat, (int)(this.x + this.width - 12), (int)(this.y + 2), (int)172, (int)0, (int)10, (int)10);
            }
        }
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        this.drawMiddleAlignedString(mat, this.mc.field_1772, this.getMessage(), this.x + this.width / 2, this.y + this.height / 2 - 3, 0xFFFFFF);
    }

    @Override
    public boolean method_25406(double x, double y, int b) {
        this.d_x = this.x;
        this.d_y = this.y;
        return this.hovered;
    }

    public void onRelease(double p_onRelease_1_, double p_onRelease_3_) {
        this.d_x = this.x;
        this.d_y = this.y;
    }

    @Override
    public boolean method_25402(double x, double y, int mb) {
        if (this.hovered && mb == 0) {
            if (this.isDisableable && x >= (double)(this.x + this.width - 12) && x < (double)(this.width + this.x - 2) && y >= (double)(this.y + 2) && y < (double)(this.y + 12)) {
                this.playDownSound(this.mc.method_1483());
                this.isShow = !this.isShow;
                for (ConfigWidgetListener hl : this.listeners) {
                    hl.onShowChanged(this);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0) {
            this.onDrag(mouseX, mouseY, deltaX, deltaY);
            return true;
        }
        return false;
    }

    protected void onDrag(double p_onDrag_1_, double p_onDrag_3_, double p_onDrag_5_, double p_onDrag_7_) {
        this.d_x += p_onDrag_5_;
        this.d_y += p_onDrag_7_;
        if (!this.snapable) {
            this.clampX(this.d_x, 0, this.mc.field_1755.field_22789 - this.width);
            this.clampY(this.d_y, 0, this.mc.field_1755.field_22790 - this.height);
        } else {
            if (this.d_x + (double)(this.width / 2) <= (double)(this.mc.field_1755.field_22789 / 2 - 10) || this.d_x + (double)(this.width / 2) >= (double)(this.mc.field_1755.field_22789 / 2 + 10)) {
                this.clampX(this.d_x, 0, this.mc.field_1755.field_22789 - this.width);
            } else {
                this.x = this.mc.field_1755.field_22789 / 2 - this.width / 2;
            }
            if (this.d_y + (double)(this.height / 2) <= (double)(this.mc.field_1755.field_22790 / 2 - 10) || this.d_y + (double)(this.height / 2) >= (double)(this.mc.field_1755.field_22790 / 2 + 10)) {
                this.clampY(this.d_y, 0, this.mc.field_1755.field_22790 - this.height);
            } else {
                this.y = this.mc.field_1755.field_22790 / 2 - this.height / 2;
            }
        }
        for (ConfigWidgetPosListener hl : this.posListeners) {
            hl.onPosChanged(this);
        }
    }

    private void clampX(double dx, int min, int max) {
        if (dx < (double)min) {
            dx = min;
        } else if (dx > (double)max) {
            dx = max;
        }
        this.x = (int)dx;
    }

    private void clampY(double dy, int min, int max) {
        if (dy < (double)min) {
            dy = min;
        } else if (dy > (double)max) {
            dy = max;
        }
        this.y = (int)dy;
    }

    private void drawMiddleAlignedString(class_4587 mat, class_327 fontRenderer, String text, int x, int y, int color) {
        fontRenderer.method_1720(mat, text, (float)(x - fontRenderer.method_1727(text) / 2), (float)y, color);
    }

    public static interface ConfigWidgetListener {
        public void onShowChanged(ConfigWidget var1);
    }

    public static interface ConfigWidgetPosListener {
        public void onPosChanged(ConfigWidget var1);
    }
}

