/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui;

import dev.emi.trinkets.api.TrinketsApi;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.ArmorRenderer;
import dlovin.inventoryhud.utils.ArmorStatus;
import dlovin.inventoryhud.utils.TrinketSaveUtils;
import dlovin.inventoryhud.utils.TrinketSlot;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.util.HashMap;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public class TrinketRenderer
extends ArmorRenderer {
    HashMap<String, TrinketSlot> slots;

    public TrinketRenderer(class_310 mc) {
        super(mc);
    }

    @Override
    public void render(class_4587 mat, int width, int height) {
        float scale = (float)this.armScale / 100.0f;
        mat.method_22903();
        mat.method_22904(0.0, 0.0, -320.0);
        TrinketsApi.getTrinketComponent((class_1309)this.mc.field_1724).ifPresent(component -> component.forEach((slotReference, stack) -> {
            String slotId = slotReference.inventory().getSlotType().getGroup() + "_" + slotReference.inventory().getSlotType().getName();
            TrinketSlot slot = this.slots().get(slotId);
            if (slot != null && slot.enabled) {
                int x = this.getX(width, (int)(16.0f * scale), slot.x, slot.aligns.HorAlign);
                int y = this.getY(height, (int)(16.0f * scale), slot.y, slot.aligns.VertAlign);
                boolean right = this.getRight(slot.x, slot.aligns.HorAlign);
                int Damage = ArmorStatus.GetDamage(stack);
                if (Damage >= 0 && Damage <= this.armAbove) {
                    String text = switch (this.armView) {
                        default -> throw new IncompatibleClassChangeError();
                        case InvConfig.ArmorView.PERCENTAGE -> this.getDamageText(String.valueOf(Damage), Damage);
                        case InvConfig.ArmorView.DAMAGE -> this.getDamageText(String.valueOf(stack.method_7919()), Damage);
                        case InvConfig.ArmorView.DAMAGE_LEFT -> this.getDamageText(String.valueOf(stack.method_7936() - stack.method_7919()), Damage);
                        case InvConfig.ArmorView.OFF -> null;
                    };
                    this.pushAndRender(mat, x, y, !right, null, (class_1799)stack, text, this.armBars, scale);
                } else if (Damage == -2) {
                    this.pushAndRender(mat, x, y, !right, null, (class_1799)stack, null, true, scale);
                } else if (this.showEmpty) {
                    this.pushAndRender(mat, x, y, !right, slot.icon, null, null, false, scale);
                }
            }
        }));
        mat.method_22909();
    }

    private void pushAndRender(class_4587 mat, int x, int y, boolean right, class_2960 resourceLocation, class_1799 itemStack, String text, boolean over, float scale) {
        mat.method_22903();
        mat.method_22904((double)x, (double)y, 0.0);
        mat.method_22905(scale, scale, 1.0f);
        this.renderElement(mat, x, y, scale, right, resourceLocation, itemStack, text, over);
        mat.method_22909();
    }

    protected HashMap<String, TrinketSlot> slots() {
        if (this.slots == null) {
            this.setupTrinkets();
        }
        return this.slots;
    }

    public void setupTrinkets() {
        this.slots = new HashMap();
        int[] i = new int[]{0};
        TrinketsApi.getPlayerSlots((class_1657)this.mc.field_1724).forEach((gKey, group) -> group.getSlots().forEach((sKey, slot) -> {
            String slotId = gKey + "_" + sKey;
            i[0] = i[0] + 20;
            this.slots.put(slotId, new TrinketSlot(0, i[0], new WidgetAligns(WidgetAligns.HAlign.LEFT, WidgetAligns.VAlign.TOP), false, slotId, slot.getIcon()));
        }));
        TrinketSaveUtils.sync();
        InventoryHUD.log(String.format("Trinkets have been initialized with %d slot(s)", this.slots.size()));
    }

    public boolean isEmpty() {
        return this.slots().isEmpty();
    }
}

